"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@xutl/test");
const assert_1 = __importDefault(require("assert"));
const __1 = require("../");
(0, test_1.describe)('defer', () => {
    let deferred;
    (0, test_1.it)('defer is a function', () => assert_1.default.equal(typeof __1.defer, 'function'));
    (0, test_1.it)('deferred is a Promise', () => {
        deferred = (0, __1.defer)();
        (0, assert_1.default)(deferred instanceof Promise);
    });
    (0, test_1.it)('deferred.resolve is a function', () => assert_1.default.equal(typeof deferred.resolve, 'function'));
    (0, test_1.it)('deferred.reject is a function', () => assert_1.default.equal(typeof deferred.reject, 'function'));
    (0, test_1.it)('deferred.promise is an object', () => assert_1.default.equal(typeof deferred.promise, 'object'));
    (0, test_1.it)('deferred.promise is a Promise', () => (0, assert_1.default)(deferred.promise instanceof Promise));
    (0, test_1.it)('deferred is resolved when calling deferred.resolve()', async () => {
        const expected = Math.random();
        deferred.resolve(expected);
        const actual = await deferred;
        assert_1.default.equal(actual, expected);
    });
    (0, test_1.it)('deferred is rejected when calling deferred.reject()', async () => {
        deferred = (0, __1.defer)();
        const expected = new Error('rejected');
        deferred.reject(expected);
        try {
            await deferred;
            (0, assert_1.default)(false);
        }
        catch (err) {
            assert_1.default.strictEqual(err, expected);
        }
    });
    (0, test_1.it)('deferred is resolved when calling deferred.callback()', async () => {
        const deferred = (0, __1.defer)();
        const expected = Math.random();
        const callback = deferred.callback;
        callback(undefined, expected);
        const actual = await deferred;
        assert_1.default.equal(actual, expected);
    });
    (0, test_1.it)('deferred is rejected when calling deferred.callback()', async () => {
        const deferred = (0, __1.defer)();
        const expected = new Error('rejected');
        const callback = deferred.callback;
        callback(expected);
        try {
            await deferred;
            (0, assert_1.default)(false);
        }
        catch (actual) {
            assert_1.default.equal(actual, expected);
        }
    });
    (0, test_1.it)('deferred can timeout', async () => {
        const deferred = (0, __1.defer)(50);
        //setTimeout(() => deferred.resolve(Math.random()), 1000);
        try {
            await deferred;
            (0, assert_1.default)(false);
        }
        catch (error) {
            if (!isErrorCode(error))
                throw error;
            assert_1.default.equal(error.code, 'ETIMEDOUT');
        }
    });
    (0, test_1.it)('deferred with timout can resolve without timeout', async () => {
        const deferred = (0, __1.defer)(50);
        const backup = (0, __1.defer)();
        process.on('uncaughtException', backup.callback);
        process.on('unhandledRejection', backup.callback);
        deferred.resolve(1);
        await deferred;
        await (0, __1.sleep)(100);
        backup.resolve(2);
        assert_1.default.equal(await backup, 2);
    });
});
function isErrorCode(e) {
    if (!e || !e.message || !e.code)
        return false;
    return true;
}
