import { AriaSliderProps } from '@react-types/slider';
import { SliderState } from '@react-stately/slider';
interface SliderAria {
    /** Props for the label element. */
    labelProps: any;
    /** Props for the root element of the slider component; groups slider inputs. */
    groupProps: any;
    /** Props for the track element. */
    trackProps: any;
    /** Props for the output element, displaying the value of the slider thumbs. */
    outputProps: any;
}
/**
 * Provides the behavior and accessibility implementation for a slider component representing one or more values.
 *
 * @param props Props for the slider.
 * @param state State for the slider, as returned by `useSliderState`.
 * @param trackRef Ref for the "track" element.  The width of this element provides the "length"
 * of the track -- the span of one dimensional space that the slider thumb can be.  It also
 * accepts click and drag motions, so that the closest thumb will follow clicks and drags on
 * the track.
 */
export declare function useSlider(props: AriaSliderProps, state: SliderState, trackLayout: any, isReversed?: boolean): SliderAria;
export {};
