import { MoveEvents } from '@react-types/shared';
import { HTMLAttributes } from 'react';
interface MoveResult {
    /** Props to spread on the target element. */
    moveProps: HTMLAttributes<HTMLElement>;
}
/**
 * Handles move interactions across mouse, touch, and keyboard, including dragging with
 * the mouse or touch, and using the arrow keys. Normalizes behavior across browsers and
 * platforms, and ignores emulated mouse events on touch devices.
 */
export declare function useMove(props: MoveEvents): MoveResult;
export {};
