import type { AriaRadioProps } from '@react-types/radio';
import type { RefObject } from 'react';
import type { RadioGroupState } from '@react-stately/radio';
import type { AccessibilityProps } from 'react-native';
export interface RadioAriaProps extends AriaRadioProps, AccessibilityProps {
    /**
     * Whether the Radio is required. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/required).
     */
    isRequired?: boolean;
    /**
     * Whether the Radio can be interacted with but cannot have its selection state changed.
     */
    isReadOnly?: boolean;
}
export interface RadioAria extends AccessibilityProps {
    /** Props for the input or Pressable/Touchable element. */
    inputProps: any;
}
/**
 * Provides the behavior and accessibility implementation for an individual
 * radio button in a radio group.
 * @param props - Props for the radio.
 * @param state - State for the radio group, as returned by `useRadioGroupState`.
 * @param ref - Ref to the HTML input element.
 */
export declare function useRadio(props: RadioAriaProps, state: RadioGroupState, _ref: RefObject<HTMLElement>): RadioAria;
