"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useComboBox = useComboBox;

// @ts-ignore

/**
 * Provides the behavior and accessibility implementation for a combo box component.
 * A combo box combines a text input with a listbox, allowing users to filter a list of options to items matching a query.
 * @param props - Props for the combo box.
 * @param state - State for the select, as returned by `useComboBoxState`.
 */
function useComboBox(props, state) {
  let {
    inputRef
  } = props; // Press handlers for the ComboBox button

  let onPress = () => {
    var _inputRef$current;

    // Focus the input field in case it isn't focused yet
    (_inputRef$current = inputRef.current) === null || _inputRef$current === void 0 ? void 0 : _inputRef$current.focus();
    state.toggle();
  };

  const onChangeText = state.setInputValue;
  return {
    labelProps: {},
    buttonProps: {
      onPress
    },
    inputProps: {
      onChangeText,
      value: state.inputValue,
      onFocus: () => {
        state.setFocused(true);
      },
      onBlur: () => {
        state.setFocused(false);
      }
    },
    listBoxProps: {}
  };
}
//# sourceMappingURL=useComboBox.js.map