import { ButtonAria } from './useButton';
import type { ToggleState } from '@react-stately/toggle';
import type { PressEvents } from '@react-native-aria/interactions';
import type { PressableProps } from 'react-native';
export declare type AriaButtonProps = PressableProps & PressEvents & {
    isDisabled: boolean;
};
export interface AriaToggleButtonProps extends AriaButtonProps {
    /** Whether the element should be selected (controlled). */
    isSelected?: boolean;
    /** Whether the element should be selected (uncontrolled). */
    defaultSelected?: boolean;
    /** Handler that is called when the element's selection state changes. */
    onChange?: (isSelected: boolean) => void;
}
export declare function useToggleButton(props: AriaToggleButtonProps, state: ToggleState): ButtonAria;
