"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useButton = useButton;

var _interactions = require("@react-native-aria/interactions");

var _utils = require("@react-aria/utils");

function useButton(props) {
  let {
    isDisabled,
    onPress,
    onPressStart,
    onPressEnd,
    onPressChange,
    ...rest
  } = props;
  let {
    pressProps,
    isPressed
  } = (0, _interactions.usePress)({
    onPressStart,
    onPressEnd,
    onPressChange,
    onPress,
    isDisabled
  });
  const mergedProps = (0, _utils.mergeProps)(pressProps, rest, {
    'aria-disabled': isDisabled,
    'role': 'button',
    'disabled': isDisabled
  });
  return {
    isPressed,
    buttonProps: mergedProps
  };
}
//# sourceMappingURL=useButton.js.map