import $c0398ad35c3639b7$exports from "./ar-AE.mjs";
import $7af657c4165927c3$exports from "./bg-BG.mjs";
import $d95d4da6d531ab81$exports from "./cs-CZ.mjs";
import $24ebda9c775dca17$exports from "./da-DK.mjs";
import $743e0dfca6cab1e9$exports from "./de-DE.mjs";
import $a2f41026e05f1c84$exports from "./el-GR.mjs";
import $43b800e97c901737$exports from "./en-US.mjs";
import $442f5f6ac211e29f$exports from "./es-ES.mjs";
import $dff280acfeb2d8ac$exports from "./et-EE.mjs";
import $51608325613944d7$exports from "./fi-FI.mjs";
import $c4a1b1eabeaa87be$exports from "./fr-FR.mjs";
import $8c74815cdee18d1b$exports from "./he-IL.mjs";
import $fd0e9ef6a7fe0ec9$exports from "./hr-HR.mjs";
import $a89a74a39eba465a$exports from "./hu-HU.mjs";
import $edc7c66594a0ae8a$exports from "./it-IT.mjs";
import $f1ab51510712db52$exports from "./ja-JP.mjs";
import $f9b672d9b82fa3d6$exports from "./ko-KR.mjs";
import $a385f3910feda499$exports from "./lt-LT.mjs";
import $4f1bde932c441789$exports from "./lv-LV.mjs";
import $914a51a8a594d5be$exports from "./nb-NO.mjs";
import $89aaf803103bb500$exports from "./nl-NL.mjs";
import $c685891476dbaaca$exports from "./pl-PL.mjs";
import $885879b9b10c2959$exports from "./pt-BR.mjs";
import $6b39616688a51692$exports from "./pt-PT.mjs";
import $f26362aed63f47e2$exports from "./ro-RO.mjs";
import $06cbade644558bf0$exports from "./ru-RU.mjs";
import $0a391ff68f9d59b1$exports from "./sk-SK.mjs";
import $8193cf0e649c7928$exports from "./sl-SI.mjs";
import $f398debcce5a5c55$exports from "./sr-SP.mjs";
import $9e9fef000aa4c013$exports from "./sv-SE.mjs";
import $c016c8183bbe3d68$exports from "./tr-TR.mjs";
import $ca4f6c8462244e62$exports from "./uk-UA.mjs";
import $2d9960c02ccac927$exports from "./zh-CN.mjs";
import $f1b682a4c8c5631c$exports from "./zh-TW.mjs";
import {useId as $1Hnir$useId, filterDOMProps as $1Hnir$filterDOMProps, mergeProps as $1Hnir$mergeProps, useRouter as $1Hnir$useRouter, useSlotId as $1Hnir$useSlotId, useEffectEvent as $1Hnir$useEffectEvent, useLayoutEffect as $1Hnir$useLayoutEffect, useResizeObserver as $1Hnir$useResizeObserver} from "@react-aria/utils";
import {useLocalizedStringFormatter as $1Hnir$useLocalizedStringFormatter, useLocale as $1Hnir$useLocale} from "@react-aria/i18n";
import {useLongPress as $1Hnir$useLongPress, usePress as $1Hnir$usePress, useHover as $1Hnir$useHover, isFocusVisible as $1Hnir$isFocusVisible, useKeyboard as $1Hnir$useKeyboard, useFocus as $1Hnir$useFocus, useInteractionModality as $1Hnir$useInteractionModality} from "@react-aria/interactions";
import {useOverlayTrigger as $1Hnir$useOverlayTrigger} from "@react-aria/overlays";
import {useSelectableList as $1Hnir$useSelectableList, useSelectableItem as $1Hnir$useSelectableItem} from "@react-aria/selection";
import {getItemCount as $1Hnir$getItemCount} from "@react-stately/collections";
import {useRef as $1Hnir$useRef, useCallback as $1Hnir$useCallback, useState as $1Hnir$useState, useEffect as $1Hnir$useEffect} from "react";


function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ /*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ var $2cbb7ca666678a14$exports = {};


































$2cbb7ca666678a14$exports = {
    "ar-AE": $c0398ad35c3639b7$exports,
    "bg-BG": $7af657c4165927c3$exports,
    "cs-CZ": $d95d4da6d531ab81$exports,
    "da-DK": $24ebda9c775dca17$exports,
    "de-DE": $743e0dfca6cab1e9$exports,
    "el-GR": $a2f41026e05f1c84$exports,
    "en-US": $43b800e97c901737$exports,
    "es-ES": $442f5f6ac211e29f$exports,
    "et-EE": $dff280acfeb2d8ac$exports,
    "fi-FI": $51608325613944d7$exports,
    "fr-FR": $c4a1b1eabeaa87be$exports,
    "he-IL": $8c74815cdee18d1b$exports,
    "hr-HR": $fd0e9ef6a7fe0ec9$exports,
    "hu-HU": $a89a74a39eba465a$exports,
    "it-IT": $edc7c66594a0ae8a$exports,
    "ja-JP": $f1ab51510712db52$exports,
    "ko-KR": $f9b672d9b82fa3d6$exports,
    "lt-LT": $a385f3910feda499$exports,
    "lv-LV": $4f1bde932c441789$exports,
    "nb-NO": $914a51a8a594d5be$exports,
    "nl-NL": $89aaf803103bb500$exports,
    "pl-PL": $c685891476dbaaca$exports,
    "pt-BR": $885879b9b10c2959$exports,
    "pt-PT": $6b39616688a51692$exports,
    "ro-RO": $f26362aed63f47e2$exports,
    "ru-RU": $06cbade644558bf0$exports,
    "sk-SK": $0a391ff68f9d59b1$exports,
    "sl-SI": $8193cf0e649c7928$exports,
    "sr-SP": $f398debcce5a5c55$exports,
    "sv-SE": $9e9fef000aa4c013$exports,
    "tr-TR": $c016c8183bbe3d68$exports,
    "uk-UA": $ca4f6c8462244e62$exports,
    "zh-CN": $2d9960c02ccac927$exports,
    "zh-TW": $f1b682a4c8c5631c$exports
};






function $168583247155ddda$export$dc9c12ed27dd1b49(props, state, ref) {
    let { type: type = "menu", isDisabled: isDisabled, trigger: trigger = "press" } = props;
    let menuTriggerId = (0, $1Hnir$useId)();
    let { triggerProps: triggerProps, overlayProps: overlayProps } = (0, $1Hnir$useOverlayTrigger)({
        type: type
    }, state, ref);
    let onKeyDown = (e)=>{
        if (isDisabled) return;
        if (trigger === "longPress" && !e.altKey) return;
        if (ref && ref.current) switch(e.key){
            case "Enter":
            case " ":
                if (trigger === "longPress") return;
            // fallthrough
            case "ArrowDown":
                // Stop propagation, unless it would already be handled by useKeyboard.
                if (!("continuePropagation" in e)) e.stopPropagation();
                e.preventDefault();
                state.toggle("first");
                break;
            case "ArrowUp":
                if (!("continuePropagation" in e)) e.stopPropagation();
                e.preventDefault();
                state.toggle("last");
                break;
            default:
                // Allow other keys.
                if ("continuePropagation" in e) e.continuePropagation();
        }
    };
    let stringFormatter = (0, $1Hnir$useLocalizedStringFormatter)((0, (/*@__PURE__*/$parcel$interopDefault($2cbb7ca666678a14$exports))), "@react-aria/menu");
    let { longPressProps: longPressProps } = (0, $1Hnir$useLongPress)({
        isDisabled: isDisabled || trigger !== "longPress",
        accessibilityDescription: stringFormatter.format("longPressMessage"),
        onLongPressStart () {
            state.close();
        },
        onLongPress () {
            state.open("first");
        }
    });
    let pressProps = {
        onPressStart (e) {
            // For consistency with native, open the menu on mouse/key down, but touch up.
            if (e.pointerType !== "touch" && e.pointerType !== "keyboard" && !isDisabled) // If opened with a screen reader, auto focus the first item.
            // Otherwise, the menu itself will be focused.
            state.toggle(e.pointerType === "virtual" ? "first" : null);
        },
        onPress (e) {
            if (e.pointerType === "touch" && !isDisabled) state.toggle();
        }
    };
    // omit onPress from triggerProps since we override it above.
    delete triggerProps.onPress;
    return {
        menuTriggerProps: {
            ...triggerProps,
            ...trigger === "press" ? pressProps : longPressProps,
            id: menuTriggerId,
            onKeyDown: onKeyDown
        },
        menuProps: {
            ...overlayProps,
            "aria-labelledby": menuTriggerId,
            autoFocus: state.focusStrategy || true,
            onClose: state.close
        }
    };
}


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 

const $d5336fe17ce95402$export$6f49b4016bfc8d56 = new WeakMap();
function $d5336fe17ce95402$export$38eaa17faae8f579(props, state, ref) {
    let { shouldFocusWrap: shouldFocusWrap = true, onKeyDown: onKeyDown, onKeyUp: onKeyUp, ...otherProps } = props;
    if (!props["aria-label"] && !props["aria-labelledby"]) console.warn("An aria-label or aria-labelledby prop is required for accessibility.");
    let domProps = (0, $1Hnir$filterDOMProps)(props, {
        labelable: true
    });
    let { listProps: listProps } = (0, $1Hnir$useSelectableList)({
        ...otherProps,
        ref: ref,
        selectionManager: state.selectionManager,
        collection: state.collection,
        disabledKeys: state.disabledKeys,
        shouldFocusWrap: shouldFocusWrap,
        linkBehavior: "override"
    });
    $d5336fe17ce95402$export$6f49b4016bfc8d56.set(state, {
        onClose: props.onClose,
        onAction: props.onAction
    });
    return {
        menuProps: (0, $1Hnir$mergeProps)(domProps, {
            onKeyDown: onKeyDown,
            onKeyUp: onKeyUp
        }, {
            role: "menu",
            ...listProps,
            onKeyDown: (e)=>{
                // don't clear the menu selected keys if the user is presses escape since escape closes the menu
                if (e.key !== "Escape") listProps.onKeyDown(e);
            }
        })
    };
}


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 




function $a2e5df62f93c7633$export$9d32628fc2aea7da(props, state, ref) {
    var _item_props;
    let { key: key, closeOnSelect: closeOnSelect, isVirtualized: isVirtualized, "aria-haspopup": hasPopup, onPressStart: pressStartProp, onPressUp: pressUpProp, onPress: onPress, onPressChange: onPressChange, onPressEnd: onPressEnd, onHoverStart: hoverStartProp, onHoverChange: onHoverChange, onHoverEnd: onHoverEnd, onKeyDown: onKeyDown, onKeyUp: onKeyUp, onFocus: onFocus, onFocusChange: onFocusChange, onBlur: onBlur } = props;
    let isTrigger = !!hasPopup;
    var _props_isDisabled;
    let isDisabled = (_props_isDisabled = props.isDisabled) !== null && _props_isDisabled !== void 0 ? _props_isDisabled : state.disabledKeys.has(key);
    var _props_isSelected;
    let isSelected = (_props_isSelected = props.isSelected) !== null && _props_isSelected !== void 0 ? _props_isSelected : state.selectionManager.isSelected(key);
    let data = (0, $d5336fe17ce95402$export$6f49b4016bfc8d56).get(state);
    let onClose = props.onClose || data.onClose;
    let onAction = isTrigger ? ()=>{} : props.onAction || data.onAction;
    let router = (0, $1Hnir$useRouter)();
    let performAction = (e)=>{
        if (onAction) onAction(key);
        if (e.target instanceof HTMLAnchorElement) router.open(e.target, e);
    };
    let role = "menuitem";
    if (!isTrigger) {
        if (state.selectionManager.selectionMode === "single") role = "menuitemradio";
        else if (state.selectionManager.selectionMode === "multiple") role = "menuitemcheckbox";
    }
    let labelId = (0, $1Hnir$useSlotId)();
    let descriptionId = (0, $1Hnir$useSlotId)();
    let keyboardId = (0, $1Hnir$useSlotId)();
    let ariaProps = {
        "aria-disabled": isDisabled || undefined,
        role: role,
        "aria-label": props["aria-label"],
        "aria-labelledby": labelId,
        "aria-describedby": [
            descriptionId,
            keyboardId
        ].filter(Boolean).join(" ") || undefined,
        "aria-controls": props["aria-controls"],
        "aria-haspopup": hasPopup,
        "aria-expanded": props["aria-expanded"]
    };
    if (state.selectionManager.selectionMode !== "none" && !isTrigger) ariaProps["aria-checked"] = isSelected;
    let item = state.collection.getItem(key);
    if (isVirtualized) {
        ariaProps["aria-posinset"] = item === null || item === void 0 ? void 0 : item.index;
        ariaProps["aria-setsize"] = (0, $1Hnir$getItemCount)(state.collection);
    }
    let onPressStart = (e)=>{
        if (e.pointerType === "keyboard") performAction(e);
        pressStartProp === null || pressStartProp === void 0 ? void 0 : pressStartProp(e);
    };
    let onPressUp = (e)=>{
        if (e.pointerType !== "keyboard") {
            performAction(e);
            // Pressing a menu item should close by default in single selection mode but not multiple
            // selection mode, except if overridden by the closeOnSelect prop.
            if (!isTrigger && onClose && (closeOnSelect !== null && closeOnSelect !== void 0 ? closeOnSelect : state.selectionManager.selectionMode !== "multiple" || state.selectionManager.isLink(key))) onClose();
        }
        pressUpProp === null || pressUpProp === void 0 ? void 0 : pressUpProp(e);
    };
    let { itemProps: itemProps, isFocused: isFocused } = (0, $1Hnir$useSelectableItem)({
        selectionManager: state.selectionManager,
        key: key,
        ref: ref,
        shouldSelectOnPressUp: true,
        allowsDifferentPressOrigin: true,
        // Disable all handling of links in useSelectable item
        // because we handle it ourselves. The behavior of menus
        // is slightly different from other collections because
        // actions are performed on key down rather than key up.
        linkBehavior: "none"
    });
    let { pressProps: pressProps, isPressed: isPressed } = (0, $1Hnir$usePress)({
        onPressStart: onPressStart,
        onPress: onPress,
        onPressUp: onPressUp,
        onPressChange: onPressChange,
        onPressEnd: onPressEnd,
        isDisabled: isDisabled
    });
    let { hoverProps: hoverProps } = (0, $1Hnir$useHover)({
        isDisabled: isDisabled,
        onHoverStart (e) {
            if (!(0, $1Hnir$isFocusVisible)()) {
                state.selectionManager.setFocused(true);
                state.selectionManager.setFocusedKey(key);
            }
            hoverStartProp === null || hoverStartProp === void 0 ? void 0 : hoverStartProp(e);
        },
        onHoverChange: onHoverChange,
        onHoverEnd: onHoverEnd
    });
    let { keyboardProps: keyboardProps } = (0, $1Hnir$useKeyboard)({
        onKeyDown: (e)=>{
            // Ignore repeating events, which may have started on the menu trigger before moving
            // focus to the menu item. We want to wait for a second complete key press sequence.
            if (e.repeat) {
                e.continuePropagation();
                return;
            }
            switch(e.key){
                case " ":
                    if (!isDisabled && state.selectionManager.selectionMode === "none" && !isTrigger && closeOnSelect !== false && onClose) onClose();
                    break;
                case "Enter":
                    // The Enter key should always close on select, except if overridden.
                    if (!isDisabled && closeOnSelect !== false && !isTrigger && onClose) onClose();
                    break;
                default:
                    if (!isTrigger) e.continuePropagation();
                    onKeyDown === null || onKeyDown === void 0 ? void 0 : onKeyDown(e);
                    break;
            }
        },
        onKeyUp: onKeyUp
    });
    let { focusProps: focusProps } = (0, $1Hnir$useFocus)({
        onBlur: onBlur,
        onFocus: onFocus,
        onFocusChange: onFocusChange
    });
    let domProps = (0, $1Hnir$filterDOMProps)(item.props, {
        isLink: !!(item === null || item === void 0 ? void 0 : (_item_props = item.props) === null || _item_props === void 0 ? void 0 : _item_props.href)
    });
    delete domProps.id;
    return {
        menuItemProps: {
            ...ariaProps,
            ...(0, $1Hnir$mergeProps)(domProps, isTrigger ? {
                onFocus: itemProps.onFocus
            } : itemProps, pressProps, hoverProps, keyboardProps, focusProps),
            tabIndex: itemProps.tabIndex != null ? -1 : undefined
        },
        labelProps: {
            id: labelId
        },
        descriptionProps: {
            id: descriptionId
        },
        keyboardShortcutProps: {
            id: keyboardId
        },
        isFocused: isFocused,
        isSelected: isSelected,
        isPressed: isPressed,
        isDisabled: isDisabled
    };
}


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 
function $3e5eb2498db5b506$export$73f7a44322579622(props) {
    let { heading: heading, "aria-label": ariaLabel } = props;
    let headingId = (0, $1Hnir$useId)();
    return {
        itemProps: {
            role: "presentation"
        },
        headingProps: heading ? {
            // Techincally, menus cannot contain headings according to ARIA.
            // We hide the heading from assistive technology, using role="presentation",
            // and only use it as a label for the nested group.
            id: headingId,
            role: "presentation"
        } : {},
        groupProps: {
            role: "group",
            "aria-label": ariaLabel,
            "aria-labelledby": heading ? headingId : undefined
        }
    };
}


/*
 * Copyright 2023 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 





const $d275435c250248f8$var$ALLOWED_INVALID_MOVEMENTS = 2;
const $d275435c250248f8$var$THROTTLE_TIME = 50;
const $d275435c250248f8$var$TIMEOUT_TIME = 1000;
const $d275435c250248f8$var$ANGLE_PADDING = Math.PI / 12; // 15°
function $d275435c250248f8$export$85ec83e04c95f50a(options) {
    let { menuRef: menuRef, submenuRef: submenuRef, isOpen: isOpen, isDisabled: isDisabled } = options;
    let prevPointerPos = (0, $1Hnir$useRef)();
    let submenuRect = (0, $1Hnir$useRef)();
    let lastProcessedTime = (0, $1Hnir$useRef)(0);
    let timeout = (0, $1Hnir$useRef)();
    let autoCloseTimeout = (0, $1Hnir$useRef)();
    let submenuSide = (0, $1Hnir$useRef)();
    let movementsTowardsSubmenuCount = (0, $1Hnir$useRef)(2);
    let [preventPointerEvents, setPreventPointerEvents] = (0, $1Hnir$useState)(false);
    let updateSubmenuRect = ()=>{
        if (submenuRef.current) {
            submenuRect.current = submenuRef.current.getBoundingClientRect();
            submenuSide.current = undefined;
        }
    };
    (0, $1Hnir$useResizeObserver)({
        ref: submenuRef,
        onResize: updateSubmenuRect
    });
    let reset = ()=>{
        setPreventPointerEvents(false);
        movementsTowardsSubmenuCount.current = $d275435c250248f8$var$ALLOWED_INVALID_MOVEMENTS;
    };
    let modality = (0, $1Hnir$useInteractionModality)();
    (0, $1Hnir$useEffect)(()=>{
        if (preventPointerEvents && menuRef.current) menuRef.current.style.pointerEvents = "none";
        else menuRef.current.style.pointerEvents = "";
    }, [
        menuRef,
        preventPointerEvents
    ]);
    (0, $1Hnir$useEffect)(()=>{
        let submenu = submenuRef.current;
        let menu = menuRef.current;
        if (isDisabled || !submenu || !isOpen || modality !== "pointer") {
            reset();
            return;
        }
        submenuRect.current = submenu.getBoundingClientRect();
        let onPointerMove = (e)=>{
            if (e.pointerType === "touch" || e.pointerType === "pen") return;
            let currentTime = Date.now();
            // Throttle
            if (currentTime - lastProcessedTime.current < $d275435c250248f8$var$THROTTLE_TIME) return;
            clearTimeout(timeout.current);
            clearTimeout(autoCloseTimeout.current);
            let { clientX: mouseX, clientY: mouseY } = e;
            if (!prevPointerPos.current) {
                prevPointerPos.current = {
                    x: mouseX,
                    y: mouseY
                };
                return;
            }
            if (!submenuRect.current) return;
            if (!submenuSide.current) submenuSide.current = mouseX > submenuRect.current.right ? "left" : "right";
            // Pointer is outside of parent menu
            if (mouseX < menu.getBoundingClientRect().left || mouseX > menu.getBoundingClientRect().right || mouseY < menu.getBoundingClientRect().top || mouseY > menu.getBoundingClientRect().bottom) {
                reset();
                return;
            }
            /* Check if pointer is moving towards submenu.
        Uses the 2-argument arctangent (https://en.wikipedia.org/wiki/Atan2) to calculate:
          - angle between previous pointer and top of submenu
          - angle between previous pointer and bottom of submenu
          - angle between previous pointer and current pointer (delta)
        If the pointer delta angle value is between the top and bottom angle values, we know the pointer is moving towards the submenu.
      */ let prevMouseX = prevPointerPos.current.x;
            let prevMouseY = prevPointerPos.current.y;
            let toSubmenuX = submenuSide.current === "right" ? submenuRect.current.left - prevMouseX : prevMouseX - submenuRect.current.right;
            let angleTop = Math.atan2(prevMouseY - submenuRect.current.top, toSubmenuX) + $d275435c250248f8$var$ANGLE_PADDING;
            let angleBottom = Math.atan2(prevMouseY - submenuRect.current.bottom, toSubmenuX) - $d275435c250248f8$var$ANGLE_PADDING;
            let anglePointer = Math.atan2(prevMouseY - mouseY, submenuSide.current === "left" ? -(mouseX - prevMouseX) : mouseX - prevMouseX);
            let isMovingTowardsSubmenu = anglePointer < angleTop && anglePointer > angleBottom;
            movementsTowardsSubmenuCount.current = isMovingTowardsSubmenu ? Math.min(movementsTowardsSubmenuCount.current + 1, $d275435c250248f8$var$ALLOWED_INVALID_MOVEMENTS) : Math.max(movementsTowardsSubmenuCount.current - 1, 0);
            if (movementsTowardsSubmenuCount.current >= $d275435c250248f8$var$ALLOWED_INVALID_MOVEMENTS) setPreventPointerEvents(true);
            else setPreventPointerEvents(false);
            lastProcessedTime.current = currentTime;
            prevPointerPos.current = {
                x: mouseX,
                y: mouseY
            };
            // If the pointer is moving towards the submenu, start a timeout to close if no other movements are made after 500ms.
            if (isMovingTowardsSubmenu) timeout.current = setTimeout(()=>{
                reset();
                autoCloseTimeout.current = setTimeout(()=>{
                    // Fire a pointerover event to trigger the menu to close.
                    // Wait until pointer-events:none is no longer applied
                    let target = document.elementFromPoint(mouseX, mouseY);
                    if (target && menu.contains(target)) target.dispatchEvent(new PointerEvent("pointerover", {
                        bubbles: true,
                        cancelable: true
                    }));
                }, 100);
            }, $d275435c250248f8$var$TIMEOUT_TIME);
        };
        window.addEventListener("pointermove", onPointerMove);
        return ()=>{
            window.removeEventListener("pointermove", onPointerMove);
            clearTimeout(timeout.current);
            clearTimeout(autoCloseTimeout.current);
            movementsTowardsSubmenuCount.current = $d275435c250248f8$var$ALLOWED_INVALID_MOVEMENTS;
        };
    }, [
        isDisabled,
        isOpen,
        menuRef,
        modality,
        setPreventPointerEvents,
        submenuRef
    ]);
}


function $0065b146e7192841$export$3819f8ee9f4ce664(props, state, ref) {
    let { parentMenuRef: parentMenuRef, submenuRef: submenuRef, type: type = "menu", isDisabled: isDisabled, node: node } = props;
    let submenuTriggerId = (0, $1Hnir$useId)();
    let overlayId = (0, $1Hnir$useId)();
    let { direction: direction } = (0, $1Hnir$useLocale)();
    let openTimeout = (0, $1Hnir$useRef)();
    let cancelOpenTimeout = (0, $1Hnir$useCallback)(()=>{
        if (openTimeout.current) {
            clearTimeout(openTimeout.current);
            openTimeout.current = undefined;
        }
    }, [
        openTimeout
    ]);
    let onSubmenuOpen = (0, $1Hnir$useEffectEvent)((focusStrategy)=>{
        cancelOpenTimeout();
        state.open(focusStrategy);
    });
    let onSubmenuClose = (0, $1Hnir$useEffectEvent)(()=>{
        cancelOpenTimeout();
        state.close();
    });
    (0, $1Hnir$useLayoutEffect)(()=>{
        return ()=>{
            cancelOpenTimeout();
        };
    }, [
        cancelOpenTimeout
    ]);
    let submenuKeyDown = (e)=>{
        switch(e.key){
            case "ArrowLeft":
                if (direction === "ltr" && e.currentTarget.contains(e.target)) {
                    e.stopPropagation();
                    onSubmenuClose();
                    ref.current.focus();
                }
                break;
            case "ArrowRight":
                if (direction === "rtl" && e.currentTarget.contains(e.target)) {
                    e.stopPropagation();
                    onSubmenuClose();
                    ref.current.focus();
                }
                break;
            case "Escape":
                e.stopPropagation();
                state.closeAll();
                break;
        }
    };
    let submenuProps = {
        id: overlayId,
        "aria-label": node.textValue,
        submenuLevel: state.submenuLevel,
        ...type === "menu" && {
            onClose: state.closeAll,
            autoFocus: state.focusStrategy,
            onKeyDown: submenuKeyDown
        }
    };
    let submenuTriggerKeyDown = (e)=>{
        switch(e.key){
            case "ArrowRight":
                if (!isDisabled) {
                    if (direction === "ltr") {
                        if (!state.isOpen) onSubmenuOpen("first");
                        if (type === "menu" && !!(submenuRef === null || submenuRef === void 0 ? void 0 : submenuRef.current) && document.activeElement === (ref === null || ref === void 0 ? void 0 : ref.current)) submenuRef.current.focus();
                    } else if (state.isOpen) onSubmenuClose();
                    else e.continuePropagation();
                }
                break;
            case "ArrowLeft":
                if (!isDisabled) {
                    if (direction === "rtl") {
                        if (!state.isOpen) onSubmenuOpen("first");
                        if (type === "menu" && !!(submenuRef === null || submenuRef === void 0 ? void 0 : submenuRef.current) && document.activeElement === (ref === null || ref === void 0 ? void 0 : ref.current)) submenuRef.current.focus();
                    } else if (state.isOpen) onSubmenuClose();
                    else e.continuePropagation();
                }
                break;
            case "Escape":
                state.closeAll();
                break;
            default:
                e.continuePropagation();
                break;
        }
    };
    let onPressStart = (e)=>{
        if (!isDisabled && (e.pointerType === "virtual" || e.pointerType === "keyboard")) // If opened with a screen reader or keyboard, auto focus the first submenu item.
        onSubmenuOpen("first");
    };
    let onPress = (e)=>{
        if (!isDisabled && (e.pointerType === "touch" || e.pointerType === "mouse")) // For touch or on a desktop device with a small screen open on press up to possible problems with
        // press up happening on the newly opened tray items
        onSubmenuOpen();
    };
    let onHoverChange = (isHovered)=>{
        if (!isDisabled) {
            if (isHovered && !state.isOpen) {
                if (!openTimeout.current) openTimeout.current = setTimeout(()=>{
                    onSubmenuOpen();
                }, 200);
            } else if (!isHovered) cancelOpenTimeout();
        }
    };
    let onBlur = (e)=>{
        if (state.isOpen && parentMenuRef.current.contains(e.relatedTarget)) onSubmenuClose();
    };
    let shouldCloseOnInteractOutside = (target)=>{
        if (target !== ref.current) return true;
        return false;
    };
    (0, $d275435c250248f8$export$85ec83e04c95f50a)({
        menuRef: parentMenuRef,
        submenuRef: submenuRef,
        isOpen: state.isOpen,
        isDisabled: isDisabled
    });
    return {
        submenuTriggerProps: {
            id: submenuTriggerId,
            "aria-controls": state.isOpen ? overlayId : undefined,
            "aria-haspopup": !isDisabled ? type : undefined,
            "aria-expanded": state.isOpen ? "true" : "false",
            onPressStart: onPressStart,
            onPress: onPress,
            onHoverChange: onHoverChange,
            onKeyDown: submenuTriggerKeyDown,
            onBlur: onBlur,
            isOpen: state.isOpen
        },
        submenuProps: submenuProps,
        popoverProps: {
            isNonModal: true,
            disableFocusManagement: true,
            shouldCloseOnInteractOutside: shouldCloseOnInteractOutside
        }
    };
}




export {$168583247155ddda$export$dc9c12ed27dd1b49 as useMenuTrigger, $d5336fe17ce95402$export$38eaa17faae8f579 as useMenu, $a2e5df62f93c7633$export$9d32628fc2aea7da as useMenuItem, $3e5eb2498db5b506$export$73f7a44322579622 as useMenuSection, $0065b146e7192841$export$3819f8ee9f4ce664 as UNSTABLE_useSubmenuTrigger};
//# sourceMappingURL=module.js.map
