"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _core = require("@babel/core");
var _babelPluginExtractMessages = _interopRequireDefault(require("@lingui/babel-plugin-extract-messages"));
var _detect = require("../detect");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const babelRe = new RegExp("\\.(" + [..._core.DEFAULT_EXTENSIONS, ".ts", ".tsx"].map(ext => ext.slice(1)).join("|") + ")$", "i");
const extractor = {
  match(filename) {
    return babelRe.test(filename);
  },
  extract(filename, localeDir, options = {}) {
    const {
      babelOptions: _babelOptions = {},
      configPath
    } = options;
    const {
      plugins = [],
      ...babelOptions
    } = _babelOptions;
    const frameworkOptions = {};
    if (options.projectType === _detect.projectType.CRA) {
      frameworkOptions.presets = ["react-app"];
    }
    (0, _core.transformFileSync)(filename, {
      ...babelOptions,
      ...frameworkOptions,
      // we override envName to avoid issues with NODE_ENV=production
      // https://github.com/lingui/js-lingui/issues/952
      envName: "development",
      plugins: ["macros", [_babelPluginExtractMessages.default, {
        localeDir,
        configPath
      }], ...plugins]
    });
  }
};
var _default = extractor;
exports.default = _default;