import * as React from 'react';
import { State } from '../State';
import { TouchEventType } from '../TouchEventType';
import { ValueOf } from '../typeUtils';
import { MouseButton } from '../web/interfaces';
export declare const baseGestureHandlerProps: readonly ["id", "enabled", "shouldCancelWhenOutside", "hitSlop", "cancelsTouchesInView", "userSelect", "activeCursor", "mouseButton", "enableContextMenu", "waitFor", "simultaneousHandlers", "blocksHandlers", "onBegan", "onFailed", "onCancelled", "onActivated", "onEnded", "onGestureEvent", "onHandlerStateChange"];
export declare const baseGestureHandlerWithMonitorProps: string[];
export interface GestureEventPayload {
    handlerTag: number;
    numberOfPointers: number;
    state: ValueOf<typeof State>;
}
export interface HandlerStateChangeEventPayload extends GestureEventPayload {
    oldState: ValueOf<typeof State>;
}
export type HitSlop = number | Partial<Record<'left' | 'right' | 'top' | 'bottom' | 'vertical' | 'horizontal', number>> | Record<'width' | 'left', number> | Record<'width' | 'right', number> | Record<'height' | 'top', number> | Record<'height' | 'bottom', number>;
export type UserSelect = 'none' | 'auto' | 'text';
export type ActiveCursor = 'auto' | 'default' | 'none' | 'context-menu' | 'help' | 'pointer' | 'progress' | 'wait' | 'cell' | 'crosshair' | 'text' | 'vertical-text' | 'alias' | 'copy' | 'move' | 'no-drop' | 'not-allowed' | 'grab' | 'grabbing' | 'e-resize' | 'n-resize' | 'ne-resize' | 'nw-resize' | 's-resize' | 'se-resize' | 'sw-resize' | 'w-resize' | 'ew-resize' | 'ns-resize' | 'nesw-resize' | 'nwse-resize' | 'col-resize' | 'row-resize' | 'all-scroll' | 'zoom-in' | 'zoom-out';
export interface GestureEvent<ExtraEventPayloadT = Record<string, unknown>> {
    nativeEvent: Readonly<GestureEventPayload & ExtraEventPayloadT>;
}
export interface HandlerStateChangeEvent<ExtraEventPayloadT = Record<string, unknown>> {
    nativeEvent: Readonly<HandlerStateChangeEventPayload & ExtraEventPayloadT>;
}
export type TouchData = {
    id: number;
    x: number;
    y: number;
    absoluteX: number;
    absoluteY: number;
};
export type GestureTouchEvent = {
    handlerTag: number;
    numberOfTouches: number;
    state: ValueOf<typeof State>;
    eventType: TouchEventType;
    allTouches: TouchData[];
    changedTouches: TouchData[];
};
export type GestureUpdateEvent<GestureEventPayloadT = Record<string, unknown>> = GestureEventPayload & GestureEventPayloadT;
export type GestureStateChangeEvent<GestureStateChangeEventPayloadT = Record<string, unknown>> = HandlerStateChangeEventPayload & GestureStateChangeEventPayloadT;
export type CommonGestureConfig = {
    enabled?: boolean;
    shouldCancelWhenOutside?: boolean;
    hitSlop?: HitSlop;
    userSelect?: UserSelect;
    activeCursor?: ActiveCursor;
    mouseButton?: MouseButton;
    enableContextMenu?: boolean;
};
export type BaseGestureHandlerProps<ExtraEventPayloadT extends Record<string, unknown> = Record<string, unknown>> = CommonGestureConfig & {
    id?: string;
    waitFor?: React.Ref<unknown> | React.Ref<unknown>[];
    simultaneousHandlers?: React.Ref<unknown> | React.Ref<unknown>[];
    blocksHandlers?: React.Ref<unknown> | React.Ref<unknown>[];
    testID?: string;
    cancelsTouchesInView?: boolean;
    onBegan?: (event: HandlerStateChangeEvent) => void;
    onFailed?: (event: HandlerStateChangeEvent) => void;
    onCancelled?: (event: HandlerStateChangeEvent) => void;
    onActivated?: (event: HandlerStateChangeEvent) => void;
    onEnded?: (event: HandlerStateChangeEvent) => void;
    onGestureEvent?: (event: GestureEvent<ExtraEventPayloadT>) => void;
    onHandlerStateChange?: (event: HandlerStateChangeEvent<ExtraEventPayloadT>) => void;
    children?: React.ReactNode;
};
export declare function filterConfig(props: Record<string, unknown>, validProps: string[], defaults?: Record<string, unknown>): {
    [x: string]: unknown;
};
export declare function findNodeHandle(node: null | number | React.Component<any, any> | React.ComponentClass<any>): null | number | React.Component<any, any> | React.ComponentClass<any>;
export declare function scheduleFlushOperations(): void;
