var _babelRuntimeHelpersExtends = $parcel$interopDefault(require("@babel/runtime/helpers/extends"));

var _react2 = require("react");

var _react = $parcel$interopDefault(_react2);

var {
  useMemo,
  useRef
} = _react2;

function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}

function $de85adf0b38f4f13e9cffd2f21$var$Item(props) {
  // eslint-disable-line @typescript-eslint/no-unused-vars
  return null;
}

$de85adf0b38f4f13e9cffd2f21$var$Item.getCollectionNode = function* getCollectionNode(props) {
  let {
    childItems,
    title,
    children
  } = props;
  let rendered = props.title || props.children;
  let textValue = props.textValue || (typeof rendered === 'string' ? rendered : '') || props['aria-label'] || '';

  if (!textValue) {
    console.warn('<Item> with non-plain text contents is unsupported by type to select for accessibility. Please add a `textValue` prop.');
  }

  yield {
    type: 'item',
    props: props,
    rendered,
    textValue,
    'aria-label': props['aria-label'],
    hasChildNodes: $de85adf0b38f4f13e9cffd2f21$var$hasChildItems(props),

    *childNodes() {
      if (childItems) {
        for (let child of childItems) {
          yield {
            type: 'item',
            value: child
          };
        }
      } else if (title) {
        let items = [];

        _react.Children.forEach(children, child => {
          items.push({
            type: 'item',
            element: child
          });
        });

        yield* items;
      }
    }

  };
};

function $de85adf0b38f4f13e9cffd2f21$var$hasChildItems(props) {
  if (props.hasChildItems != null) {
    return props.hasChildItems;
  }

  if (props.childItems) {
    return true;
  }

  if (props.title && _react.Children.count(props.children) > 0) {
    return true;
  }

  return false;
} // We don't want getCollectionNode to show up in the type definition


let Item = $de85adf0b38f4f13e9cffd2f21$var$Item;
exports.Item = Item;

function $fce9f2c25e6e4c6ae9d7b8458177776c$var$Section(props) {
  // eslint-disable-line @typescript-eslint/no-unused-vars
  return null;
}

$fce9f2c25e6e4c6ae9d7b8458177776c$var$Section.getCollectionNode = function* getCollectionNode(props) {
  let {
    children,
    title,
    items
  } = props;
  yield {
    type: 'section',
    hasChildNodes: true,
    rendered: title,
    'aria-label': props['aria-label'],

    *childNodes() {
      if (typeof children === 'function') {
        if (!items) {
          throw new Error('props.children was a function but props.items is missing');
        }

        for (let item of items) {
          yield {
            type: 'item',
            value: item,
            renderer: children
          };
        }
      } else {
        let items = [];

        _react.Children.forEach(children, child => {
          items.push({
            type: 'item',
            element: child
          });
        });

        yield* items;
      }
    }

  };
}; // We don't want getCollectionNode to show up in the type definition


let Section = $fce9f2c25e6e4c6ae9d7b8458177776c$var$Section;
exports.Section = Section;

class $f9fc6bc72d334a59f09d47517f9a056a$export$CollectionBuilder {
  constructor() {
    this.context = void 0;
    this.cache = new WeakMap();
  }

  build(props, context) {
    this.context = context;
    return $f9fc6bc72d334a59f09d47517f9a056a$var$iterable(() => this.iterateCollection(props));
  }

  *iterateCollection(props) {
    let {
      children,
      items
    } = props;

    if (typeof children === 'function') {
      if (!items) {
        throw new Error('props.children was a function but props.items is missing');
      }

      for (let item of props.items) {
        yield* this.getFullNode({
          value: item
        }, {
          renderer: children
        });
      }
    } else {
      let items = [];

      _react.Children.forEach(children, child => {
        items.push(child);
      });

      let index = 0;

      for (let item of items) {
        let nodes = this.getFullNode({
          element: item,
          index: index
        }, {});

        for (let node of nodes) {
          index++;
          yield node;
        }
      }
    }
  }

  getKey(item, partialNode, state, parentKey) {
    if (item.key != null) {
      return item.key;
    }

    if (partialNode.type === 'cell' && partialNode.key != null) {
      return "" + parentKey + partialNode.key;
    }

    let v = partialNode.value;

    if (v != null) {
      var _v$key;

      let key = (_v$key = v.key) != null ? _v$key : v.id;

      if (key == null) {
        throw new Error('No key found for item');
      }

      return key;
    }

    return parentKey ? parentKey + "." + partialNode.index : "$." + partialNode.index;
  }

  getChildState(state, partialNode) {
    return {
      renderer: partialNode.renderer || state.renderer
    };
  }

  *getFullNode(partialNode, state, parentKey, parentNode) {
    // If there's a value instead of an element on the node, and a parent renderer function is available,
    // use it to render an element for the value.
    let element = partialNode.element;

    if (!element && partialNode.value && state && state.renderer) {
      let cached = this.cache.get(partialNode.value);

      if (cached && (!cached.shouldInvalidate || !cached.shouldInvalidate(this.context))) {
        cached.index = partialNode.index;
        yield cached;
        return;
      }

      element = state.renderer(partialNode.value);
    } // If there's an element with a getCollectionNode function on its type, then it's a supported component.
    // Call this function to get a partial node, and recursively build a full node from there.


    if (_react.isValidElement(element)) {
      let type = element.type;

      if (typeof type !== 'function' || typeof type.getCollectionNode !== 'function') {
        let name = typeof element.type === 'function' ? element.type.name : element.type;
        throw new Error("Unknown element <" + name + "> in collection.");
      }

      let childNodes = type.getCollectionNode(element.props, this.context);
      let index = partialNode.index;
      let result = childNodes.next();

      while (!result.done && result.value) {
        let childNode = result.value;
        partialNode.index = index;
        let nodes = this.getFullNode(_babelRuntimeHelpersExtends({}, childNode, {
          key: childNode.element ? null : this.getKey(element, partialNode, state, parentKey),
          index,
          wrapper: $f9fc6bc72d334a59f09d47517f9a056a$var$compose(partialNode.wrapper, childNode.wrapper)
        }), this.getChildState(state, childNode), parentKey ? "" + parentKey + element.key : element.key, parentNode);
        let children = [...nodes];

        for (let node of children) {
          // Cache the node based on its value
          node.value = childNode.value || partialNode.value;

          if (node.value) {
            this.cache.set(node.value, node);
          } // The partial node may have specified a type for the child in order to specify a constraint.
          // Verify that the full node that was built recursively matches this type.


          if (partialNode.type && node.type !== partialNode.type) {
            throw new Error("Unsupported type <" + $f9fc6bc72d334a59f09d47517f9a056a$var$capitalize(node.type) + "> in <" + $f9fc6bc72d334a59f09d47517f9a056a$var$capitalize(parentNode.type) + ">. Only <" + $f9fc6bc72d334a59f09d47517f9a056a$var$capitalize(partialNode.type) + "> is supported.");
          }

          index++;
          yield node;
        }

        result = childNodes.next(children);
      }

      return;
    } // Ignore invalid elements


    if (partialNode.key == null) {
      return;
    } // Create full node


    let builder = this;
    let node = {
      type: partialNode.type,
      props: partialNode.props,
      key: partialNode.key,
      parentKey: parentNode ? parentNode.key : null,
      value: partialNode.value,
      level: parentNode ? parentNode.level + 1 : 0,
      index: partialNode.index,
      rendered: partialNode.rendered,
      textValue: partialNode.textValue,
      'aria-label': partialNode['aria-label'],
      wrapper: partialNode.wrapper,
      shouldInvalidate: partialNode.shouldInvalidate,
      hasChildNodes: partialNode.hasChildNodes,
      childNodes: $f9fc6bc72d334a59f09d47517f9a056a$var$iterable(function* () {
        if (!partialNode.hasChildNodes) {
          return;
        }

        let index = 0;

        for (let child of partialNode.childNodes()) {
          // Ensure child keys are globally unique by prepending the parent node's key
          if (child.key != null) {
            child.key = "" + node.key + child.key;
          }

          child.index = index;
          let nodes = builder.getFullNode(child, builder.getChildState(state, child), node.key, node);

          for (let node of nodes) {
            index++;
            yield node;
          }
        }
      })
    };
    yield node;
  }

} // Wraps an iterator function as an iterable object, and caches the results.


function $f9fc6bc72d334a59f09d47517f9a056a$var$iterable(iterator) {
  let cache = [];
  let iterable = null;
  return {
    *[Symbol.iterator]() {
      for (let item of cache) {
        yield item;
      }

      if (!iterable) {
        iterable = iterator();
      }

      for (let item of iterable) {
        cache.push(item);
        yield item;
      }
    }

  };
}

function $f9fc6bc72d334a59f09d47517f9a056a$var$compose(outer, inner) {
  if (outer && inner) {
    return element => outer(inner(element));
  }

  if (outer) {
    return outer;
  }

  if (inner) {
    return inner;
  }
}

function $f9fc6bc72d334a59f09d47517f9a056a$var$capitalize(str) {
  return str[0].toUpperCase() + str.slice(1);
}

function useCollection(props, factory, context, invalidators) {
  if (invalidators === void 0) {
    invalidators = [];
  }

  let builder = useMemo(() => new $f9fc6bc72d334a59f09d47517f9a056a$export$CollectionBuilder(), []);
  let prev = useRef(null);
  return useMemo(() => {
    let nodes = builder.build(props, context);
    prev.current = factory(nodes, prev.current);
    return prev.current; // Don't invalidate when any prop changes, just the two we care about.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [builder, props.children, props.items, context, ...invalidators]);
}

exports.useCollection = useCollection;

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
const $f87be1a9afd2842b9b36ca75398a185$var$cache = new WeakMap();

function getItemCount(collection) {
  let count = $f87be1a9afd2842b9b36ca75398a185$var$cache.get(collection);

  if (count != null) {
    return count;
  }

  count = 0;

  for (let item of collection) {
    if (item.type === 'section') {
      count += getItemCount(item.childNodes);
    } else {
      count++;
    }
  }

  $f87be1a9afd2842b9b36ca75398a185$var$cache.set(collection, count);
  return count;
}

exports.getItemCount = getItemCount;
//# sourceMappingURL=main.js.map
