import React from 'react';
import type { IFormControlProps } from './types';
export declare type IFormControlContext = Omit<ReturnType<typeof useFormControlProvider>, 'htmlProps'>;
export declare const FormControlContext: React.Context<{}>;
export declare function useFormControlProvider(props: IFormControlProps): {
    isRequired: boolean;
    isInvalid: boolean;
    isReadOnly: boolean;
    isDisabled: boolean;
    hasFeedbackText: boolean;
    setHasFeedbackText: React.Dispatch<React.SetStateAction<boolean>>;
    hasHelpText: boolean;
    setHasHelpText: React.Dispatch<React.SetStateAction<boolean>>;
    nativeID: string;
    labelId: string;
    feedbackId: string;
    helpTextId: string;
    htmlProps: {
        children?: any;
        _text?: Partial<import("../../primitives").ITextProps> | undefined;
        bg?: import("../../types").ResponsiveValue<import("../../types").ColorType | import("../../primitives/Box/types").ILinearGradientProps>;
        background?: import("../../types").ResponsiveValue<import("../../types").ColorType | import("../../primitives/Box/types").ILinearGradientProps>;
        bgColor?: import("../../types").ResponsiveValue<import("../../types").ColorType | import("../../primitives/Box/types").ILinearGradientProps>;
        backgroundColor?: import("../../types").ResponsiveValue<import("../../types").ColorType | import("../../primitives/Box/types").ILinearGradientProps>;
        hitSlop?: import("react-native").Insets | undefined;
        onLayout?: ((event: import("react-native").LayoutChangeEvent) => void) | undefined;
        pointerEvents?: "auto" | "none" | "box-none" | "box-only" | undefined;
        removeClippedSubviews?: boolean | undefined;
        style?: import("react-native").StyleProp<import("react-native").ViewStyle>;
        testID?: string | undefined;
        collapsable?: boolean | undefined;
        needsOffscreenAlphaCompositing?: boolean | undefined;
        renderToHardwareTextureAndroid?: boolean | undefined;
        focusable?: boolean | undefined;
        shouldRasterizeIOS?: boolean | undefined;
        isTVSelectable?: boolean | undefined;
        hasTVPreferredFocus?: boolean | undefined;
        tvParallaxProperties?: import("react-native").TVParallaxProperties | undefined;
        tvParallaxShiftDistanceX?: number | undefined;
        tvParallaxShiftDistanceY?: number | undefined;
        tvParallaxTiltAngle?: number | undefined;
        tvParallaxMagnification?: number | undefined;
        onStartShouldSetResponder?: ((event: import("react-native").GestureResponderEvent) => boolean) | undefined;
        onMoveShouldSetResponder?: ((event: import("react-native").GestureResponderEvent) => boolean) | undefined;
        onResponderEnd?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onResponderGrant?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onResponderReject?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onResponderMove?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onResponderRelease?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onResponderStart?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onResponderTerminationRequest?: ((event: import("react-native").GestureResponderEvent) => boolean) | undefined;
        onResponderTerminate?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onStartShouldSetResponderCapture?: ((event: import("react-native").GestureResponderEvent) => boolean) | undefined;
        onMoveShouldSetResponderCapture?: ((event: import("react-native").GestureResponderEvent) => boolean) | undefined;
        onTouchStart?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onTouchMove?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onTouchEnd?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onTouchCancel?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        onTouchEndCapture?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
        accessible?: boolean | undefined;
        accessibilityActions?: readonly Readonly<{
            name: string;
            label?: string | undefined;
        }>[] | undefined;
        accessibilityLabel?: string | undefined;
        accessibilityRole?: import("react-native").AccessibilityRole | undefined;
        accessibilityState?: import("react-native").AccessibilityState | undefined;
        accessibilityHint?: string | undefined;
        accessibilityValue?: import("react-native").AccessibilityValue | undefined;
        onAccessibilityAction?: ((event: import("react-native").AccessibilityActionEvent) => void) | undefined;
        accessibilityLiveRegion?: "none" | "polite" | "assertive" | undefined;
        importantForAccessibility?: "auto" | "no" | "yes" | "no-hide-descendants" | undefined;
        accessibilityElementsHidden?: boolean | undefined;
        accessibilityViewIsModal?: boolean | undefined;
        onAccessibilityEscape?: (() => void) | undefined;
        onAccessibilityTap?: (() => void) | undefined;
        onMagicTap?: (() => void) | undefined;
        accessibilityIgnoresInvertColors?: boolean | undefined;
        safeArea?: number | boolean | undefined;
        safeAreaX?: number | boolean | undefined;
        safeAreaY?: number | boolean | undefined;
        safeAreaTop?: number | boolean | undefined;
        safeAreaBottom?: number | boolean | undefined;
        safeAreaLeft?: number | boolean | undefined;
        safeAreaRight?: number | boolean | undefined;
        _web?: Partial<IFormControlProps> | undefined;
        _ios?: Partial<IFormControlProps> | undefined;
        _android?: Partial<IFormControlProps> | undefined;
        _light?: Partial<IFormControlProps> | undefined;
        _dark?: Partial<IFormControlProps> | undefined;
        _important?: Partial<IFormControlProps> | undefined;
        p?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        margin?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        m?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        marginTop?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        mt?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        marginRight?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        mr?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        marginBottom?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        mb?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        marginLeft?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        ml?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        marginX?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        mx?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        marginY?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        my?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        padding?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        paddingTop?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        pt?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        paddingRight?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        pr?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        paddingBottom?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        pb?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        paddingLeft?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        pl?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        paddingX?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        px?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        paddingY?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        py?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        borderWidth?: import("../../types").ResponsiveValue<"2" | "8" | "4" | "1" | "0" | (string & {}) | (number & {})>;
        borderStyle?: import("../../types").ResponsiveValue<import("csstype").Property.BorderStyle | undefined>;
        borderColor?: import("../../types").ColorType;
        borderRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        borderTopWidth?: import("../../types").ResponsiveValue<"2" | "8" | "4" | "1" | "0" | (string & {}) | (number & {})>;
        borderTopStyle?: import("../../types").ResponsiveValue<import("csstype").Property.BorderTopStyle | undefined>;
        borderTopColor?: import("../../types").ColorType;
        borderTopLeftRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        borderTopRightRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        borderRightWidth?: import("../../types").ResponsiveValue<"2" | "8" | "4" | "1" | "0" | (string & {}) | (number & {})>;
        borderRightStyle?: import("../../types").ResponsiveValue<import("csstype").Property.BorderRightStyle | undefined>;
        borderRightColor?: import("../../types").ColorType;
        borderBottomWidth?: import("../../types").ResponsiveValue<"2" | "8" | "4" | "1" | "0" | (string & {}) | (number & {})>;
        borderBottomStyle?: import("../../types").ResponsiveValue<import("csstype").Property.BorderBottomStyle | undefined>;
        borderBottomColor?: import("../../types").ColorType;
        borderBottomLeftRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        borderBottomRightRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        borderLeftWidth?: import("../../types").ResponsiveValue<"2" | "8" | "4" | "1" | "0" | (string & {}) | (number & {})>;
        borderLeftStyle?: import("../../types").ResponsiveValue<import("csstype").Property.BorderLeftStyle | undefined>;
        borderLeftColor?: import("../../types").ColorType;
        borderX?: import("../../types").ResponsiveValue<import("csstype").Property.BorderLeft<0 | (string & {})> | undefined>;
        borderY?: import("../../types").ResponsiveValue<import("csstype").Property.BorderTop<0 | (string & {})> | undefined>;
        rounded?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        width?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        w?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        height?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        h?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        display?: import("../../types").ResponsiveValue<import("csstype").Property.Display | undefined>;
        minWidth?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        minW?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        minH?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        minHeight?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        maxWidth?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        maxW?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        maxHeight?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        maxH?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        size?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        overflow?: import("../../types").ResponsiveValue<import("csstype").Property.Overflow | undefined>;
        overflowX?: import("../../types").ResponsiveValue<import("csstype").Property.OverflowX | undefined>;
        overflowY?: import("../../types").ResponsiveValue<import("csstype").Property.OverflowY | undefined>;
        alignItems?: import("../../types").ResponsiveValue<import("csstype").Property.AlignItems | undefined>;
        alignContent?: import("../../types").ResponsiveValue<import("csstype").Property.AlignContent | undefined>;
        justifyItems?: import("../../types").ResponsiveValue<import("csstype").Property.JustifyItems | undefined>;
        justifyContent?: import("../../types").ResponsiveValue<import("csstype").Property.JustifyContent | undefined>;
        flexWrap?: import("../../types").ResponsiveValue<import("csstype").Property.FlexWrap | undefined>;
        flexDirection?: import("../../types").ResponsiveValue<import("csstype").Property.FlexDirection | undefined>;
        flex?: import("../../types").ResponsiveValue<import("csstype").Property.Flex<0 | (string & {})> | undefined>;
        flexGrow?: import("../../types").ResponsiveValue<import("csstype").Property.FlexGrow | undefined>;
        flexShrink?: import("../../types").ResponsiveValue<import("csstype").Property.FlexShrink | undefined>;
        flexBasis?: import("../../types").ResponsiveValue<import("csstype").Property.FlexBasis<0 | (string & {})> | undefined>;
        alignSelf?: import("../../types").ResponsiveValue<import("csstype").Property.AlignSelf | undefined>;
        position?: import("../../types").ResponsiveValue<import("csstype").Property.Position | undefined>;
        zIndex?: unknown;
        top?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        right?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        bottom?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        left?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
        outlineColor?: import("../../types").ResponsiveValue<import("csstype").Property.OutlineColor | undefined>;
        outlineStyle?: import("../../types").ResponsiveValue<import("csstype").Property.OutlineStyle | undefined>;
        opacity?: import("../../types").ResponsiveValue<0 | 50 | 100 | 5 | 10 | 20 | 40 | 80 | 30 | 60 | (string & {}) | (number & {}) | 70 | 25 | 75 | 90 | 95>;
        fontWeight?: import("../../types").ResponsiveValue<"light" | "bold" | "black" | "medium" | "normal" | (string & {}) | (number & {}) | "hairline" | "thin" | "semibold" | "extrabold" | "extraBlack">;
        shadow?: import("../../types").ResponsiveValue<"6" | "2" | "8" | "3" | "4" | "5" | "7" | "1" | "0" | "none" | (string & {}) | "9" | (number & {})>;
        color?: import("../../types").ColorType;
        tintColor?: import("../../types").ColorType;
        textDecorationColor?: import("../../types").ColorType;
        fontFamily?: import("../../types").ResponsiveValue<"body" | (string & {}) | (number & {}) | "heading" | "mono">;
        fontSize?: import("../../types").ResponsiveValue<"sm" | "2xs" | "xs" | "md" | "xl" | "3xl" | "5xl" | "lg" | "6xl" | "7xl" | "4xl" | "2xl" | (string & {}) | (number & {}) | "8xl" | "9xl">;
        lineHeight?: import("../../types").ResponsiveValue<"sm" | "2xs" | "xs" | "md" | "xl" | "3xl" | "5xl" | "lg" | "4xl" | "2xl" | (string & {}) | (number & {})>;
        letterSpacing?: import("../../types").ResponsiveValue<"sm" | "xs" | "md" | "xl" | "lg" | "2xl" | (string & {}) | (number & {})>;
        textDecorationLine?: import("../../types").ResponsiveValue<import("csstype").Property.TextDecorationLine | undefined>;
        fontStyle?: import("../../types").ResponsiveValue<import("csstype").Property.FontStyle | undefined>;
        textAlign?: import("../../types").ResponsiveValue<import("csstype").Property.TextAlign | undefined>;
        textTransform?: import("../../types").ResponsiveValue<import("csstype").Property.TextTransform | undefined>;
        textDecoration?: unknown;
        txtDecor?: unknown;
        borderTopRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        borderLeftRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        borderRightRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        roundedTopLeft?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        roundedTopRight?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        roundedBottomLeft?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        roundedBottomRight?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        roundedTop?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        borderBottomRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        roundedBottom?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        roundedLeft?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        roundedRight?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
        flexDir?: import("../../types").ResponsiveValue<import("csstype").Property.FlexDirection | undefined>;
        boxSize?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
        variant?: unknown;
        colorScheme?: import("../../types").ColorSchemeType;
    };
};
/**
 * React hook that provides the props that should be spread on to
 * input fields (`input`, `select`, `textarea`, etc.).
 *
 * It provides a convenient way to control a form fields, validation
 * and helper text.
 */
export declare function useFormControl(props: IFormControlProps): {
    nativeID: string | undefined;
    disabled: boolean;
    readOnly: boolean;
    required: boolean;
    accessibilityInvalid: boolean | undefined;
    accessibilityRequired: boolean | undefined;
    accessibilityReadOnly: boolean | undefined;
    accessibilityDescribedBy: string | undefined;
    children?: any;
    p?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    style?: import("react-native").StyleProp<import("react-native").ViewStyle>;
    margin?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    m?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    marginTop?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    mt?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    marginRight?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    mr?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    marginBottom?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    mb?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    marginLeft?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    ml?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    marginX?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    mx?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    marginY?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    my?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    padding?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    paddingTop?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    pt?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    paddingRight?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    pr?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    paddingBottom?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    pb?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    paddingLeft?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    pl?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    paddingX?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    px?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    paddingY?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    py?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    borderWidth?: import("../../types").ResponsiveValue<"2" | "8" | "4" | "1" | "0" | (string & {}) | (number & {})>;
    borderStyle?: import("../../types").ResponsiveValue<import("csstype").Property.BorderStyle | undefined>;
    borderColor?: import("../../types").ColorType;
    borderRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    borderTopWidth?: import("../../types").ResponsiveValue<"2" | "8" | "4" | "1" | "0" | (string & {}) | (number & {})>;
    borderTopStyle?: import("../../types").ResponsiveValue<import("csstype").Property.BorderTopStyle | undefined>;
    borderTopColor?: import("../../types").ColorType;
    borderTopLeftRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    borderTopRightRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    borderRightWidth?: import("../../types").ResponsiveValue<"2" | "8" | "4" | "1" | "0" | (string & {}) | (number & {})>;
    borderRightStyle?: import("../../types").ResponsiveValue<import("csstype").Property.BorderRightStyle | undefined>;
    borderRightColor?: import("../../types").ColorType;
    borderBottomWidth?: import("../../types").ResponsiveValue<"2" | "8" | "4" | "1" | "0" | (string & {}) | (number & {})>;
    borderBottomStyle?: import("../../types").ResponsiveValue<import("csstype").Property.BorderBottomStyle | undefined>;
    borderBottomColor?: import("../../types").ColorType;
    borderBottomLeftRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    borderBottomRightRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    borderLeftWidth?: import("../../types").ResponsiveValue<"2" | "8" | "4" | "1" | "0" | (string & {}) | (number & {})>;
    borderLeftStyle?: import("../../types").ResponsiveValue<import("csstype").Property.BorderLeftStyle | undefined>;
    borderLeftColor?: import("../../types").ColorType;
    borderX?: import("../../types").ResponsiveValue<import("csstype").Property.BorderLeft<0 | (string & {})> | undefined>;
    borderY?: import("../../types").ResponsiveValue<import("csstype").Property.BorderTop<0 | (string & {})> | undefined>;
    rounded?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    width?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    w?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    height?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    h?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    display?: import("../../types").ResponsiveValue<import("csstype").Property.Display | undefined>;
    minWidth?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    minW?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    minH?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    minHeight?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    maxWidth?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    maxW?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    maxHeight?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    maxH?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    size?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    overflow?: import("../../types").ResponsiveValue<import("csstype").Property.Overflow | undefined>;
    overflowX?: import("../../types").ResponsiveValue<import("csstype").Property.OverflowX | undefined>;
    overflowY?: import("../../types").ResponsiveValue<import("csstype").Property.OverflowY | undefined>;
    alignItems?: import("../../types").ResponsiveValue<import("csstype").Property.AlignItems | undefined>;
    alignContent?: import("../../types").ResponsiveValue<import("csstype").Property.AlignContent | undefined>;
    justifyItems?: import("../../types").ResponsiveValue<import("csstype").Property.JustifyItems | undefined>;
    justifyContent?: import("../../types").ResponsiveValue<import("csstype").Property.JustifyContent | undefined>;
    flexWrap?: import("../../types").ResponsiveValue<import("csstype").Property.FlexWrap | undefined>;
    flexDirection?: import("../../types").ResponsiveValue<import("csstype").Property.FlexDirection | undefined>;
    flex?: import("../../types").ResponsiveValue<import("csstype").Property.Flex<0 | (string & {})> | undefined>;
    flexGrow?: import("../../types").ResponsiveValue<import("csstype").Property.FlexGrow | undefined>;
    flexShrink?: import("../../types").ResponsiveValue<import("csstype").Property.FlexShrink | undefined>;
    flexBasis?: import("../../types").ResponsiveValue<import("csstype").Property.FlexBasis<0 | (string & {})> | undefined>;
    alignSelf?: import("../../types").ResponsiveValue<import("csstype").Property.AlignSelf | undefined>;
    position?: import("../../types").ResponsiveValue<import("csstype").Property.Position | undefined>;
    zIndex?: unknown;
    top?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    right?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    bottom?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    left?: import("../../types").ResponsiveValue<"px" | "full" | "6" | "2" | "8" | "3" | "12" | "4" | "16" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "1" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | (number & {})>;
    outlineColor?: import("../../types").ResponsiveValue<import("csstype").Property.OutlineColor | undefined>;
    outlineStyle?: import("../../types").ResponsiveValue<import("csstype").Property.OutlineStyle | undefined>;
    bg?: import("../../types").ResponsiveValue<import("../../types").ColorType | import("../../primitives/Box/types").ILinearGradientProps>;
    backgroundColor?: import("../../types").ResponsiveValue<import("../../types").ColorType | import("../../primitives/Box/types").ILinearGradientProps>;
    bgColor?: import("../../types").ResponsiveValue<import("../../types").ColorType | import("../../primitives/Box/types").ILinearGradientProps>;
    colorScheme?: import("../../types").ColorSchemeType;
    opacity?: import("../../types").ResponsiveValue<0 | 50 | 100 | 5 | 10 | 20 | 40 | 80 | 30 | 60 | (string & {}) | (number & {}) | 70 | 25 | 75 | 90 | 95>;
    fontWeight?: import("../../types").ResponsiveValue<"light" | "bold" | "black" | "medium" | "normal" | (string & {}) | (number & {}) | "hairline" | "thin" | "semibold" | "extrabold" | "extraBlack">;
    shadow?: import("../../types").ResponsiveValue<"6" | "2" | "8" | "3" | "4" | "5" | "7" | "1" | "0" | "none" | (string & {}) | "9" | (number & {})>;
    color?: import("../../types").ColorType;
    tintColor?: import("../../types").ColorType;
    textDecorationColor?: import("../../types").ColorType;
    fontFamily?: import("../../types").ResponsiveValue<"body" | (string & {}) | (number & {}) | "heading" | "mono">;
    fontSize?: import("../../types").ResponsiveValue<"sm" | "2xs" | "xs" | "md" | "xl" | "3xl" | "5xl" | "lg" | "6xl" | "7xl" | "4xl" | "2xl" | (string & {}) | (number & {}) | "8xl" | "9xl">;
    lineHeight?: import("../../types").ResponsiveValue<"sm" | "2xs" | "xs" | "md" | "xl" | "3xl" | "5xl" | "lg" | "4xl" | "2xl" | (string & {}) | (number & {})>;
    letterSpacing?: import("../../types").ResponsiveValue<"sm" | "xs" | "md" | "xl" | "lg" | "2xl" | (string & {}) | (number & {})>;
    textDecorationLine?: import("../../types").ResponsiveValue<import("csstype").Property.TextDecorationLine | undefined>;
    fontStyle?: import("../../types").ResponsiveValue<import("csstype").Property.FontStyle | undefined>;
    pointerEvents?: "auto" | "none" | "box-none" | "box-only" | undefined;
    textAlign?: import("../../types").ResponsiveValue<import("csstype").Property.TextAlign | undefined>;
    textTransform?: import("../../types").ResponsiveValue<import("csstype").Property.TextTransform | undefined>;
    background?: import("../../types").ResponsiveValue<import("../../types").ColorType | import("../../primitives/Box/types").ILinearGradientProps>;
    textDecoration?: unknown;
    testID?: string | undefined;
    txtDecor?: unknown;
    borderTopRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    borderLeftRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    borderRightRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    roundedTopLeft?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    roundedTopRight?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    roundedBottomLeft?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    roundedBottomRight?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    roundedTop?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    borderBottomRadius?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    roundedBottom?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    roundedLeft?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    roundedRight?: import("../../types").ResponsiveValue<"full" | "sm" | "xs" | "md" | "xl" | "3xl" | "lg" | "2xl" | "none" | (string & {}) | (number & {})>;
    flexDir?: import("../../types").ResponsiveValue<import("csstype").Property.FlexDirection | undefined>;
    boxSize?: import("../../types").ResponsiveValue<"px" | "full" | "sm" | "6" | "2xs" | "2" | "8" | "xs" | "3" | "12" | "md" | "4" | "16" | "xl" | "5" | "24" | "32" | "7" | "0.5" | "2.5" | "lg" | "1" | "2xl" | "1.5" | "10" | "20" | "64" | "0" | "80" | (string & {}) | "3.5" | "9" | "40" | "48" | "56" | "72" | "96" | "1/2" | "1/3" | "2/3" | "1/4" | "2/4" | "3/4" | "1/5" | "2/5" | "3/5" | "4/5" | "1/6" | "2/6" | "3/6" | "4/6" | "5/6" | "container" | "3xs" | (number & {})>;
    _web?: Partial<IFormControlProps> | undefined;
    _ios?: Partial<IFormControlProps> | undefined;
    _android?: Partial<IFormControlProps> | undefined;
    _light?: Partial<IFormControlProps> | undefined;
    _dark?: Partial<IFormControlProps> | undefined;
    _important?: Partial<IFormControlProps> | undefined;
    variant?: unknown;
    safeArea?: number | boolean | undefined;
    safeAreaY?: number | boolean | undefined;
    safeAreaTop?: number | boolean | undefined;
    safeAreaBottom?: number | boolean | undefined;
    safeAreaLeft?: number | boolean | undefined;
    safeAreaX?: number | boolean | undefined;
    safeAreaRight?: number | boolean | undefined;
    onLayout?: ((event: import("react-native").LayoutChangeEvent) => void) | undefined;
    accessible?: boolean | undefined;
    accessibilityActions?: readonly Readonly<{
        name: string;
        label?: string | undefined;
    }>[] | undefined;
    accessibilityLabel?: string | undefined;
    accessibilityRole?: import("react-native").AccessibilityRole | undefined;
    accessibilityState?: import("react-native").AccessibilityState | undefined;
    accessibilityHint?: string | undefined;
    accessibilityValue?: import("react-native").AccessibilityValue | undefined;
    onAccessibilityAction?: ((event: import("react-native").AccessibilityActionEvent) => void) | undefined;
    accessibilityLiveRegion?: "none" | "polite" | "assertive" | undefined;
    importantForAccessibility?: "auto" | "no" | "yes" | "no-hide-descendants" | undefined;
    accessibilityElementsHidden?: boolean | undefined;
    accessibilityViewIsModal?: boolean | undefined;
    onAccessibilityEscape?: (() => void) | undefined;
    onAccessibilityTap?: (() => void) | undefined;
    onMagicTap?: (() => void) | undefined;
    accessibilityIgnoresInvertColors?: boolean | undefined;
    _text?: Partial<import("../../primitives").ITextProps> | undefined;
    hitSlop?: import("react-native").Insets | undefined;
    removeClippedSubviews?: boolean | undefined;
    collapsable?: boolean | undefined;
    needsOffscreenAlphaCompositing?: boolean | undefined;
    renderToHardwareTextureAndroid?: boolean | undefined;
    focusable?: boolean | undefined;
    shouldRasterizeIOS?: boolean | undefined;
    isTVSelectable?: boolean | undefined;
    hasTVPreferredFocus?: boolean | undefined;
    tvParallaxProperties?: import("react-native").TVParallaxProperties | undefined;
    tvParallaxShiftDistanceX?: number | undefined;
    tvParallaxShiftDistanceY?: number | undefined;
    tvParallaxTiltAngle?: number | undefined;
    tvParallaxMagnification?: number | undefined;
    onStartShouldSetResponder?: ((event: import("react-native").GestureResponderEvent) => boolean) | undefined;
    onMoveShouldSetResponder?: ((event: import("react-native").GestureResponderEvent) => boolean) | undefined;
    onResponderEnd?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onResponderGrant?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onResponderReject?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onResponderMove?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onResponderRelease?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onResponderStart?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onResponderTerminationRequest?: ((event: import("react-native").GestureResponderEvent) => boolean) | undefined;
    onResponderTerminate?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onStartShouldSetResponderCapture?: ((event: import("react-native").GestureResponderEvent) => boolean) | undefined;
    onMoveShouldSetResponderCapture?: ((event: import("react-native").GestureResponderEvent) => boolean) | undefined;
    onTouchStart?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onTouchMove?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onTouchEnd?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onTouchCancel?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
    onTouchEndCapture?: ((event: import("react-native").GestureResponderEvent) => void) | undefined;
};
export declare const useFormControlContext: () => IFormControlContext;
