export const v3CompatibleTheme = {
  borders: {
    'none': 0,
    '1px': '1px solid',
    '2px': '2px solid',
    '4px': '4px solid'
  },
  breakpoints: {
    base: 0,
    sm: 480,
    md: 768,
    lg: 992,
    xl: 1280
  },
  colors: {
    contrastThreshold: 7,
    white: '#FFFFFF',
    black: '#000000',
    lightText: '#FFFFFF',
    darkText: '#000000',
    rose: {
      '50': '#fff1f2',
      '100': '#ffe4e6',
      '200': '#fecdd3',
      '300': '#fda4af',
      '400': '#fb7185',
      '500': '#f43f5e',
      '600': '#e11d48',
      '700': '#be123c',
      '800': '#9f1239',
      '900': '#881337'
    },
    pink: {
      '50': '#fdf2f8',
      '100': '#fce7f3',
      '200': '#fbcfe8',
      '300': '#f9a8d4',
      '400': '#f472b6',
      '500': '#ec4899',
      '600': '#db2777',
      '700': '#be185d',
      '800': '#9d174d',
      '900': '#831843'
    },
    fuchsia: {
      '50': '#fdf4ff',
      '100': '#fae8ff',
      '200': '#f5d0fe',
      '300': '#f0abfc',
      '400': '#e879f9',
      '500': '#d946ef',
      '600': '#c026d3',
      '700': '#a21caf',
      '800': '#86198f',
      '900': '#701a75'
    },
    purple: {
      '50': '#faf5ff',
      '100': '#f3e8ff',
      '200': '#e9d5ff',
      '300': '#d8b4fe',
      '400': '#c084fc',
      '500': '#a855f7',
      '600': '#9333ea',
      '700': '#7e22ce',
      '800': '#6b21a8',
      '900': '#581c87'
    },
    violet: {
      '50': '#f5f3ff',
      '100': '#ede9fe',
      '200': '#ddd6fe',
      '300': '#c4b5fd',
      '400': '#a78bfa',
      '500': '#8b5cf6',
      '600': '#7c3aed',
      '700': '#6d28d9',
      '800': '#5b21b6',
      '900': '#4c1d95'
    },
    indigo: {
      '50': '#eef2ff',
      '100': '#e0e7ff',
      '200': '#c7d2fe',
      '300': '#a5b4fc',
      '400': '#818cf8',
      '500': '#6366f1',
      '600': '#4f46e5',
      '700': '#4338ca',
      '800': '#3730a3',
      '900': '#312e81'
    },
    blue: {
      '50': '#eff6ff',
      '100': '#dbeafe',
      '200': '#bfdbfe',
      '300': '#93c5fd',
      '400': '#60a5fa',
      '500': '#3b82f6',
      '600': '#2563eb',
      '700': '#1d4ed8',
      '800': '#1e40af',
      '900': '#1e3a8a'
    },
    lightBlue: {
      '50': '#f0f9ff',
      '100': '#e0f2fe',
      '200': '#bae6fd',
      '300': '#7dd3fc',
      '400': '#38bdf8',
      '500': '#0ea5e9',
      '600': '#0284c7',
      '700': '#0369a1',
      '800': '#075985',
      '900': '#0c4a6e'
    },
    darkBlue: {
      '50': '#dbf4ff',
      '100': '#addbff',
      '200': '#7cc2ff',
      '300': '#4aa9ff',
      '400': '#1a91ff',
      '500': '#0077e6',
      '600': '#005db4',
      '700': '#004282',
      '800': '#002851',
      '900': '#000e21'
    },
    cyan: {
      '50': '#ecfeff',
      '100': '#cffafe',
      '200': '#a5f3fc',
      '300': '#67e8f9',
      '400': '#22d3ee',
      '500': '#06b6d4',
      '600': '#0891b2',
      '700': '#0e7490',
      '800': '#155e75',
      '900': '#164e63'
    },
    teal: {
      '50': '#f0fdfa',
      '100': '#ccfbf1',
      '200': '#99f6e4',
      '300': '#5eead4',
      '400': '#2dd4bf',
      '500': '#14b8a6',
      '600': '#0d9488',
      '700': '#0f766e',
      '800': '#115e59',
      '900': '#134e4a'
    },
    emerald: {
      '50': '#ecfdf5',
      '100': '#d1fae5',
      '200': '#a7f3d0',
      '300': '#6ee7b7',
      '400': '#34d399',
      '500': '#10b981',
      '600': '#059669',
      '700': '#047857',
      '800': '#065f46',
      '900': '#064e3b'
    },
    green: {
      '50': '#f0fdf4',
      '100': '#dcfce7',
      '200': '#bbf7d0',
      '300': '#86efac',
      '400': '#4ade80',
      '500': '#22c55e',
      '600': '#16a34a',
      '700': '#15803d',
      '800': '#166534',
      '900': '#14532d'
    },
    lime: {
      '50': '#f7fee7',
      '100': '#ecfccb',
      '200': '#d9f99d',
      '300': '#bef264',
      '400': '#a3e635',
      '500': '#84cc16',
      '600': '#65a30d',
      '700': '#4d7c0f',
      '800': '#3f6212',
      '900': '#365314'
    },
    yellow: {
      '50': '#fefce8',
      '100': '#fef9c3',
      '200': '#fef08a',
      '300': '#fde047',
      '400': '#facc15',
      '500': '#eab308',
      '600': '#ca8a04',
      '700': '#a16207',
      '800': '#854d0e',
      '900': '#713f12'
    },
    amber: {
      '50': '#fffbeb',
      '100': '#fef3c7',
      '200': '#fde68a',
      '300': '#fcd34d',
      '400': '#fbbf24',
      '500': '#f59e0b',
      '600': '#d97706',
      '700': '#b45309',
      '800': '#92400e',
      '900': '#78350f'
    },
    orange: {
      '50': '#fff7ed',
      '100': '#ffedd5',
      '200': '#fed7aa',
      '300': '#fdba74',
      '400': '#fb923c',
      '500': '#f97316',
      '600': '#ea580c',
      '700': '#c2410c',
      '800': '#9a3412',
      '900': '#7c2d12'
    },
    red: {
      '50': '#fef2f2',
      '100': '#fee2e2',
      '200': '#fecaca',
      '300': '#fca5a5',
      '400': '#f87171',
      '500': '#ef4444',
      '600': '#dc2626',
      '700': '#b91c1c',
      '800': '#991b1b',
      '900': '#7f1d1d'
    },
    warmGray: {
      '50': '#fafaf9',
      '100': '#f5f5f4',
      '200': '#e7e5e4',
      '300': '#d6d3d1',
      '400': '#a8a29e',
      '500': '#78716c',
      '600': '#57534e',
      '700': '#44403c',
      '800': '#292524',
      '900': '#1c1917'
    },
    trueGray: {
      '50': '#fafafa',
      '100': '#f5f5f5',
      '200': '#e5e5e5',
      '300': '#d4d4d4',
      '400': '#a3a3a3',
      '500': '#737373',
      '600': '#525252',
      '700': '#404040',
      '800': '#262626',
      '900': '#171717'
    },
    gray: {
      '50': '#fafafa',
      '100': '#f4f4f5',
      '200': '#e4e4e7',
      '300': '#d4d4d8',
      '400': '#a1a1aa',
      '500': '#71717a',
      '600': '#52525b',
      '700': '#3f3f46',
      '800': '#27272a',
      '900': '#18181b'
    },
    coolGray: {
      '50': '#f9fafb',
      '100': '#f3f4f6',
      '200': '#e5e7eb',
      '300': '#d1d5db',
      '400': '#9ca3af',
      '500': '#6b7280',
      '600': '#4b5563',
      '700': '#374151',
      '800': '#1f2937',
      '900': '#111827'
    },
    blueGray: {
      '50': '#f8fafc',
      '100': '#f1f5f9',
      '200': '#e2e8f0',
      '300': '#cbd5e1',
      '400': '#94a3b8',
      '500': '#64748b',
      '600': '#475569',
      '700': '#334155',
      '800': '#1e293b',
      '900': '#0f172a'
    },
    dark: {
      '50': '#18181b',
      '100': '#27272a',
      '200': '#3f3f46',
      '300': '#52525b',
      '400': '#71717a',
      '500': '#a1a1aa',
      '600': '#d4d4d8',
      '700': '#e4e4e7',
      '800': '#f4f4f5',
      '900': '#fafafa'
    },
    danger: {
      '50': '#fff1f2',
      '100': '#ffe4e6',
      '200': '#fecdd3',
      '300': '#fda4af',
      '400': '#fb7185',
      '500': '#f43f5e',
      '600': '#e11d48',
      '700': '#be123c',
      '800': '#9f1239',
      '900': '#881337'
    },
    error: {
      '50': '#fef2f2',
      '100': '#fee2e2',
      '200': '#fecaca',
      '300': '#fca5a5',
      '400': '#f87171',
      '500': '#ef4444',
      '600': '#dc2626',
      '700': '#b91c1c',
      '800': '#991b1b',
      '900': '#7f1d1d'
    },
    success: {
      '50': '#f0fdf4',
      '100': '#dcfce7',
      '200': '#bbf7d0',
      '300': '#86efac',
      '400': '#4ade80',
      '500': '#22c55e',
      '600': '#16a34a',
      '700': '#15803d',
      '800': '#166534',
      '900': '#14532d'
    },
    warning: {
      '50': '#fff7ed',
      '100': '#ffedd5',
      '200': '#fed7aa',
      '300': '#fdba74',
      '400': '#fb923c',
      '500': '#f97316',
      '600': '#ea580c',
      '700': '#c2410c',
      '800': '#9a3412',
      '900': '#7c2d12'
    },
    muted: {
      '50': '#fafafa',
      '100': '#f5f5f5',
      '200': '#e5e5e5',
      '300': '#d4d4d4',
      '400': '#a3a3a3',
      '500': '#737373',
      '600': '#525252',
      '700': '#404040',
      '800': '#262626',
      '900': '#171717'
    },
    primary: {
      '50': '#ecfeff',
      '100': '#cffafe',
      '200': '#a5f3fc',
      '300': '#67e8f9',
      '400': '#22d3ee',
      '500': '#06b6d4',
      '600': '#0891b2',
      '700': '#0e7490',
      '800': '#155e75',
      '900': '#164e63'
    },
    info: {
      '50': '#f0f9ff',
      '100': '#e0f2fe',
      '200': '#bae6fd',
      '300': '#7dd3fc',
      '400': '#38bdf8',
      '500': '#0ea5e9',
      '600': '#0284c7',
      '700': '#0369a1',
      '800': '#075985',
      '900': '#0c4a6e'
    },
    secondary: {
      '50': '#fdf2f8',
      '100': '#fce7f3',
      '200': '#fbcfe8',
      '300': '#f9a8d4',
      '400': '#f472b6',
      '500': '#ec4899',
      '600': '#db2777',
      '700': '#be185d',
      '800': '#9d174d',
      '900': '#831843'
    },
    light: {
      '50': '#fafaf9',
      '100': '#f5f5f4',
      '200': '#e7e5e4',
      '300': '#d6d3d1',
      '400': '#a8a29e',
      '500': '#78716c',
      '600': '#57534e',
      '700': '#44403c',
      '800': '#292524',
      '900': '#1c1917'
    },
    tertiary: {
      '50': '#ecfdf5',
      '100': '#d1fae5',
      '200': '#a7f3d0',
      '300': '#6ee7b7',
      '400': '#34d399',
      '500': '#10b981',
      '600': '#059669',
      '700': '#047857',
      '800': '#065f46',
      '900': '#064e3b'
    }
  },
  radii: {
    none: 0,
    sm: 2,
    md: 4,
    lg: 6,
    xl: 8,
    pill: 25,
    full: 9999
  },
  letterSpacings: {
    'xxs': -1.5,
    'xs': -0.5,
    'sm': 0,
    'md': 0.1,
    'lg': 0.15,
    'xl': 0.25,
    '2xl': 0.4,
    '3xl': 0.5,
    '4xl': 1.25,
    '5xl': 1.5
  },
  lineHeights: {
    '3': '12px',
    '4': '16px',
    '5': '20px',
    '6': '24px',
    '7': '28px',
    '8': '32px',
    '9': '36px',
    '10': '40px',
    'none': 1,
    'shorter': 1.25,
    'short': 1.375,
    'base': 1.5,
    'tall': 1.625,
    'taller': '2'
  },
  fontWeights: {
    hairline: 100,
    thin: 200,
    light: 300,
    normal: 400,
    medium: 500,
    semibold: 600,
    bold: 700,
    extrabold: 800,
    black: 900
  },
  fonts: {},
  fontSizes: {
    'xxs': 10,
    'xs': 12,
    'sm': 14,
    'md': 16,
    'lg': 18,
    'xl': 20,
    '2xl': 24,
    '3xl': 30,
    '4xl': 36,
    '5xl': 48,
    '6xl': 60,
    '7xl': 72,
    '8xl': 96,
    '9xl': 128
  },
  sizes: {
    '0': '0px',
    '1': '4px',
    '2': '8px',
    '3': '12px',
    '4': '16px',
    '5': '20px',
    '6': '24px',
    '7': '28px',
    '8': '32px',
    '9': '36px',
    '10': '40px',
    '12': '48px',
    '16': '64px',
    '20': '80px',
    '24': '96px',
    '32': '128px',
    '40': '160px',
    '48': '192px',
    '56': '224px',
    '64': '256px',
    '72': '288px',
    '80': '320px',
    '96': '384px',
    'px': '1px',
    '0.5': '2px',
    '1.5': '6px',
    '2.5': '10px',
    '3.5': '14px',
    '3xs': '224px',
    '2xs': '256px',
    'xs': '320px',
    'sm': '384px',
    'md': '448px',
    'lg': '512px',
    'xl': '576px',
    '2xl': '672px',
    'container': {
      sm: '640px',
      md: '768px',
      lg: '1024px',
      xl: '1280px'
    }
  },
  space: {
    '0': '0px',
    '1': '4px',
    '2': '8px',
    '3': '12px',
    '4': '16px',
    '5': '20px',
    '6': '24px',
    '7': '28px',
    '8': '32px',
    '9': '36px',
    '10': '40px',
    '12': '48px',
    '16': '64px',
    '20': '80px',
    '24': '96px',
    '32': '128px',
    '40': '160px',
    '48': '192px',
    '56': '224px',
    '64': '256px',
    '72': '288px',
    '80': '320px',
    '96': '384px',
    'px': '1px',
    '0.5': '2px',
    '1.5': '6px',
    '2.5': '10px',
    '3.5': '14px'
  },
  components: {
    FlatList: {
      baseStyle: {},
      defaultProps: {}
    },
    KeyboardAvoidingView: {
      baseStyle: {},
      defaultProps: {}
    },
    ScrollView: {
      baseStyle: {},
      defaultProps: {}
    },
    SectionList: {
      baseStyle: {},
      defaultProps: {}
    },
    StatusBar: {
      baseStyle: {},
      defaultProps: {}
    },
    Accordion: {},
    AccordionItem: {},
    AccordionIcon: {},
    AccordionSummary: {},
    AccordionDetails: {
      baseStyle: {
        p: 3
      }
    },
    Actionsheet: {
      defaultProps: {
        size: 'full'
      }
    },
    ActionsheetContent: {
      baseStyle: {
        alignItems: 'center',
        p: 2,
        borderRadius: 'none',
        roundedTop: 10,
        _dragIndicator: {
          bg: 'coolGray.400',
          height: 1,
          width: 9,
          borderRadius: 2
        }
      }
    },
    ActionsheetItem: {
      defaultProps: {
        variant: 'unstyled'
      }
    },
    Alert: {
      baseStyle: {
        alignItems: 'center',
        justifyContent: 'flex-start',
        p: 3,
        space: 3,
        borderRadius: 'md',
        _actionProps: {
          alignSelf: 'center',
          ml: 'auto'
        },
        _text: {
          fontSize: 'sm',
          lineHeight: 5,
          color: 'gray.700'
        }
      },
      variants: {},
      defaultProps: {
        colorScheme: 'primary',
        variant: 'subtle'
      }
    },
    AlertDescription: {
      baseStyle: {
        _text: {
          fontSize: 'sm'
        },
        flexShrink: 1
      }
    },
    AlertTitle: {
      baseStyle: {
        _text: {
          fontSize: 'md',
          lineHeight: 5,
          fontWeight: 'bold'
        }
      }
    },
    AlertIcon: {
      baseStyle: {
        size: 6
      }
    },
    Avatar: {
      sizes: {
        '2xs': {
          width: '4',
          height: '4',
          fontSize: 'xs'
        },
        'xs': {
          width: '6',
          height: '6',
          fontSize: 'sm'
        },
        'sm': {
          width: '8',
          height: '8',
          fontSize: 'md'
        },
        'md': {
          width: '12',
          height: '12',
          fontSize: 'lg'
        },
        'lg': {
          width: '16',
          height: '16',
          fontSize: 'xl'
        },
        'xl': {
          width: '24',
          height: '24',
          fontSize: '2xl'
        },
        '2xl': {
          width: '32',
          height: '32',
          fontSize: '3xl'
        },
        'full': {
          width: '100%',
          height: '100%',
          fontSize: '4xl'
        }
      },
      defaultProps: {
        size: 'md'
      }
    },
    AvatarBadge: {},
    AvatarGroup: {},
    Badge: {
      baseStyle: {
        px: 1,
        _text: {
          fontSize: 'xs',
          fontWeight: 'bold'
        }
      },
      variants: {},
      defaultProps: {
        variant: 'subtle',
        colorScheme: 'muted'
      }
    },
    Box: {
      baseStyle: {},
      defaultProps: {}
    },
    Breadcrumb: {
      baseStyle: {
        width: 'auto',
        height: 'auto',
        display: 'flex',
        flexDirection: 'row'
      },
      defaultProps: {
        direction: 'row',
        wrap: 'wrap'
      }
    },
    Button: {
      variants: {},
      sizes: {
        lg: {
          px: 6,
          py: 3,
          _text: {
            fontSize: 'lg'
          }
        },
        md: {
          px: 4,
          py: 3,
          _text: {
            fontSize: 'md'
          }
        },
        sm: {
          px: 4,
          py: 2,
          _text: {
            fontSize: 'sm'
          }
        },
        xs: {
          px: 2,
          py: 1,
          _text: {
            fontSize: 'xs'
          }
        }
      },
      defaultProps: {
        variant: 'solid',
        size: 'md',
        colorScheme: 'primary'
      }
    },
    ButtonGroup: {
      baseStyle: {
        direction: 'row'
      },
      defaultProps: {
        space: 2
      }
    },
    Center: {
      sizes: {
        'xs': {
          height: 10,
          width: 10
        },
        'sm': {
          height: 12,
          width: 12
        },
        'md': {
          height: 16,
          width: 16
        },
        'lg': {
          height: 24,
          width: 24
        },
        'xl': {
          height: 32,
          width: 32
        },
        '2xl': {
          height: 40,
          width: 40
        }
      }
    },
    Checkbox: {
      sizes: {
        lg: {
          _icon: {
            size: 6
          },
          _text: {
            fontSize: 'xl'
          }
        },
        md: {
          _icon: {
            size: 5
          },
          _text: {
            fontSize: 'lg'
          }
        },
        sm: {
          _icon: {
            size: 4
          },
          _text: {
            fontSize: 'md'
          }
        }
      },
      defaultProps: {
        defaultIsChecked: false,
        size: 'sm',
        colorScheme: 'primary'
      }
    },
    CircularProgress: {
      sizes: {
        'xs': {
          height: 6,
          width: 6
        },
        'sm': {
          height: 8,
          width: 8
        },
        'md': {
          height: 16,
          width: 16
        },
        'lg': {
          height: 20,
          width: 20
        },
        'xl': {
          height: 24,
          width: 24
        },
        '2xl': {
          height: 32,
          width: 32
        }
      },
      defaultProps: {
        thickness: 8,
        colorScheme: 'primary',
        size: 'lg'
      }
    },
    Code: {
      baseStyle: {
        _text: {
          fontFamily: 'monospace',
          fontSize: 'sm'
        },
        borderRadius: 'sm',
        px: 2,
        py: 1
      },
      variants: {},
      defaultProps: {
        variant: 'subtle',
        colorScheme: 'muted'
      }
    },
    Container: {
      baseStyle: {
        maxWidth: '80%'
      }
    },
    Divider: {
      defaultProps: {
        orientation: 'horizontal',
        size: 1
      }
    },
    Fade: {
      defaultProps: {
        entryDuration: 500,
        exitDuration: 500
      }
    },
    FAB: {
      baseStyle: {
        shadow: 7
      },
      defaultProps: {
        variant: 'solid',
        colorScheme: 'primary',
        rounded: 'full',
        zIndex: 20,
        placementProps: {
          'top-right': {
            top: 12,
            right: 4,
            position: 'absolute'
          },
          'top-left': {
            top: 12,
            left: 4,
            position: 'absolute'
          },
          'bottom-right': {
            bottom: 4,
            right: 4,
            position: 'absolute'
          },
          'bottom-left': {
            bottom: 4,
            left: 4,
            position: 'absolute'
          }
        },
        p: 4,
        placement: 'bottom-right'
      }
    },
    Flex: {
      defaultProps: {
        flexDirection: 'column'
      }
    },
    FormControl: {},
    FormControlLabel: {
      baseStyle: {
        _text: {
          fontSize: 'md'
        },
        astrickColor: 'error.400',
        mb: 2,
        mr: 3
      }
    },
    FormControlHelperText: {},
    FormControlErrorMessage: {
      baseStyle: {
        mt: 2,
        _text: {
          fontSize: 'xs',
          color: 'error.400'
        }
      }
    },
    Heading: {
      sizes: {
        '4xl': {
          fontSize: ['6xl', null, '7xl']
        },
        '3xl': {
          fontSize: ['5xl', null, '6xl']
        },
        '2xl': {
          fontSize: ['4xl', null, '5xl']
        },
        'xl': {
          fontSize: ['3xl', null, '4xl']
        },
        'lg': {
          fontSize: ['2xl', null, '3xl']
        },
        'md': {
          fontSize: 'xl'
        },
        'sm': {
          fontSize: 'md'
        },
        'xs': {
          fontSize: 'sm'
        }
      },
      defaultProps: {
        size: 'xl'
      }
    },
    HStack: {
      baseStyle: {},
      defaultProps: {}
    },
    VStack: {
      baseStyle: {},
      defaultProps: {}
    },
    Icon: {
      sizes: {
        'xxs': 2,
        'xs': 4,
        'sm': 6,
        'md': 8,
        'lg': 10,
        'xl': 12,
        '2xl': 16,
        '3xl': 20,
        '4xl': 24,
        '5xl': 32,
        '6xl': 64
      },
      defaultProps: {
        size: 'md',
        color: 'primary'
      }
    },
    IconButton: {
      baseStyle: {
        borderRadius: 'md'
      },
      sizes: {
        lg: {
          p: 3
        },
        md: {
          p: 2
        },
        sm: {
          p: 1
        }
      },
      defaultProps: {
        variant: 'ghost',
        size: 'md'
      }
    },
    Image: {
      baseStyle: {
        maxWidth: '100%'
      },
      sizes: {
        '2xs': {
          size: 6
        },
        'xs': {
          size: 10
        },
        'sm': {
          size: 16
        },
        'md': {
          size: 20
        },
        'lg': {
          size: 24
        },
        'xl': {
          size: 32
        },
        '2xl': {
          size: 64
        },
        'full': {
          size: '100%'
        }
      },
      defaultProps: {}
    },
    Input: {
      defaultProps: {
        size: 'md',
        variant: 'outline'
      },
      variants: {},
      sizes: {
        '2xl': {
          fontSize: '2xl'
        },
        'xl': {
          fontSize: 'xl'
        },
        'lg': {
          fontSize: 'lg'
        },
        'md': {
          fontSize: 'md'
        },
        'sm': {
          fontSize: 'sm'
        },
        'xs': {
          fontSize: 'xs'
        }
      }
    },
    Kbd: {
      defaultProps: {}
    },
    Link: {
      baseStyle: {
        width: 'auto',
        height: 'auto'
      }
    },
    List: {},
    ListItem: {
      baseStyle: {
        py: 2,
        borderColor: 'gray.300'
      },
      defaultProps: {
        start: 1
      }
    },
    ListIcon: {
      baseStyle: {
        mr: 8,
        size: 'md'
      }
    },
    Menu: {},
    MenuGroup: {},
    MenuItem: {
      defaultProps: {
        _disabled: {
          opacity: 0.5
        }
      }
    },
    Modal: {
      baseStyle: {
        width: '100%',
        height: '100%',
        justifyContent: 'center',
        alignItems: 'center'
      },
      sizes: {
        sm: {
          contentSize: {
            width: '60%'
          }
        },
        md: {
          contentSize: {
            width: '75%'
          }
        },
        lg: {
          contentSize: {
            width: '90%'
          }
        },
        full: {
          contentSize: {
            width: '100%'
          }
        }
      },
      defaultProps: {
        size: 'lg',
        closeOnOverlayClick: true
      }
    },
    ModalContent: {},
    ModalHeader: {
      baseStyle: {
        pb: 3,
        pr: 6,
        _text: {
          fontSize: 'xl',
          fontWeight: 'bold'
        }
      }
    },
    ModalBody: {},
    ModalFooter: {
      baseStyle: {
        py: 2,
        flexDirection: 'row',
        justifyContent: 'flex-end',
        flexWrap: 'wrap',
        pr: 2
      }
    },
    ModalOverlay: {
      baseStyle: {
        position: 'absolute',
        left: 0,
        top: 0,
        opacity: 0.5,
        right: 0,
        bottom: 0
      }
    },
    ModalCloseButton: {},
    NumberInput: {
      defaultProps: {
        size: 'sm',
        step: 1,
        min: null,
        max: null,
        defaultValue: '0',
        keepWithinRange: true,
        clampValueOnBlur: true,
        focusInputOnChange: true,
        getAriaValueText: true
      }
    },
    NumberInputStepper: {},
    PinInput: {
      sizes: {
        '2xl': {
          fontSize: '2xl',
          p: 3,
          width: '56px',
          height: '56px',
          textAlign: 'center',
          borderRadius: 'lg'
        },
        'xl': {
          fontSize: 'xl',
          p: 3,
          width: '52px',
          height: '52px',
          textAlign: 'center',
          borderRadius: 'lg'
        },
        'lg': {
          fontSize: 'lg',
          p: 2,
          width: '48px',
          height: '48px',
          textAlign: 'center',
          borderRadius: 'md'
        },
        'md': {
          fontSize: 'md',
          p: 2,
          width: '40px',
          height: '40px',
          textAlign: 'center',
          borderRadius: 'md'
        },
        'sm': {
          fontSize: 'sm',
          p: 1,
          width: '30px',
          height: '30px',
          textAlign: 'center',
          borderRadius: 'md'
        },
        'xs': {
          fontSize: 'xs',
          p: 1,
          width: '24px',
          height: '24px',
          textAlign: 'center',
          borderRadius: 'md'
        }
      },
      defaultProps: {
        placeholder: '○',
        size: 'md',
        manageFocus: true,
        space: 1
      }
    },
    PopoverCloseButton: {},
    PopoverBody: {},
    PopoverContent: {},
    PopoverHeader: {
      baseStyle: {
        p: 3,
        _text: {
          fontWeight: 600
        }
      }
    },
    PopoverArrow: {},
    PopoverFooter: {},
    Progress: {
      defaultProps: {
        colorScheme: 'primary',
        size: 'sm',
        rounded: 'full',
        min: 0,
        max: 100,
        value: 0,
        isIndeterminate: false
      },
      sizes: {
        'xs': {
          height: 1
        },
        'sm': {
          height: 2
        },
        'md': {
          height: 3
        },
        'lg': {
          height: 4
        },
        'xl': {
          height: 5
        },
        '2xl': {
          height: 6
        }
      }
    },
    Radio: {
      sizes: {
        lg: {
          _icon: {
            size: 4
          },
          _text: {
            fontSize: 'lg'
          }
        },
        md: {
          _icon: {
            size: 3
          },
          _text: {
            fontSize: 'md'
          }
        },
        sm: {
          _icon: {
            size: 2
          },
          _text: {
            fontSize: 'sm'
          }
        }
      },
      defaultProps: {
        defaultIsChecked: false,
        size: 'md',
        colorScheme: 'primary'
      }
    },
    ScaleFade: {
      defaultProps: {
        duration: 500,
        initialScale: 0.9
      }
    },
    Select: {
      baseStyle: {
        customDropdownIconProps: {
          size: 5,
          mr: 2
        },
        _actionSheetContent: {}
      },
      defaultProps: {
        variant: 'outline'
      }
    },
    SelectItem: {
      baseStyle: {
        p: 1,
        px: 2,
        borderRadius: 0,
        minH: 0
      }
    },
    SimpleGrid: {
      baseStyle: {},
      defaultProps: {}
    },
    Skeleton: {
      defaultProps: {
        variant: 'text'
      }
    },
    SliderFilledTrack: {},
    SliderThumb: {},
    SliderTrack: {},
    Slider: {
      defaultProps: {
        size: 'sm'
      },
      sizes: {
        lg: {
          thumbSize: 6,
          sliderSize: 6
        },
        md: {
          thumbSize: 5,
          sliderSize: 5
        },
        sm: {
          thumbSize: 4,
          sliderSize: 4
        }
      }
    },
    Slide: {
      defaultProps: {
        duration: 500,
        placement: 'bottom'
      }
    },
    SlideFade: {
      defaultProps: {
        duration: 500,
        offsetX: 10,
        offsetY: 10
      }
    },
    Spinner: {
      baseStyle: {
        color: 'primary.400'
      },
      sizes: {
        sm: 'small',
        lg: 'large'
      },
      defaultProps: {
        size: 'large'
      }
    },
    Stack: {
      baseStyle: {},
      defaultProps: {},
      sizes: {
        'gutter': 0,
        '2xs': 1,
        'xs': 2,
        'sm': 3,
        'md': 4,
        'lg': 6,
        'xl': 7,
        '2xl': 8
      }
    },
    Stat: {
      defaultProps: {
        _statLabel: {
          fontSize: 'xl'
        },
        _statNumber: {
          fontSize: '4xl',
          fontWeight: 'bold',
          my: 2
        },
        _statHelpText: {
          _text: {
            color: 'gray.500',
            fontSize: 'xl'
          },
          flexDirection: 'row',
          alignItems: 'center'
        },
        _statGroup: {
          flexWrap: 'wrap',
          space: 4,
          justifyContent: 'space-between'
        }
      }
    },
    Switch: {
      sizes: {
        sm: {
          style: {
            transform: [{
              scale: 0.75
            }]
          }
        },
        md: {},
        lg: {
          style: {
            transform: [{
              scale: 1.25
            }]
          },
          margin: 1
        }
      },
      defaultProps: {
        size: 'md',
        colorScheme: 'primary'
      }
    },
    Tabs: {
      variants: {},
      sizes: {
        sm: {
          activeTabStyle: {
            _text: {
              fontSize: 'sm'
            },
            py: 2,
            px: 3
          },
          inactiveTabStyle: {
            _text: {
              fontSize: 'sm'
            },
            py: 2,
            px: 3
          }
        },
        md: {
          activeTabStyle: {
            _text: {
              fontSize: 'md'
            },
            py: 3,
            px: 4
          },
          inactiveTabStyle: {
            _text: {
              fontSize: 'md'
            },
            py: 3,
            px: 4
          }
        },
        lg: {
          activeTabStyle: {
            _text: {
              fontSize: 'lg'
            },
            py: 4,
            px: 5
          },
          inactiveTabStyle: {
            _text: {
              fontSize: 'lg'
            },
            py: 4,
            px: 5
          }
        }
      },
      defaultProps: {
        size: 'md',
        variant: 'outline',
        colorScheme: 'primary'
      }
    },
    Tag: {
      variants: {},
      baseStyle: {
        _text: {
          fontWeight: 'medium'
        },
        alignItems: 'center',
        justifyContent: 'center',
        flexDirection: 'row',
        display: 'flex'
      },
      sizes: {
        sm: {
          minH: 5,
          minW: 5,
          _text: {
            fontSize: 'xs'
          },
          p: 1,
          borderRadius: 'sm'
        },
        md: {
          minH: 6,
          minW: 6,
          _text: {
            fontSize: 'sm'
          },
          borderRadius: 'md',
          p: 2
        },
        lg: {
          minH: 8,
          minW: 8,
          _text: {
            fontSize: 'md'
          },
          borderRadius: 'md',
          p: 3
        }
      },
      defaultProps: {
        size: 'md',
        variant: 'subtle',
        colorScheme: 'primary'
      }
    },
    Text: {
      defaultProps: {}
    },
    AppBar: {
      defaultProps: {
        colorScheme: 'primary'
      }
    },
    TextArea: {
      baseStyle: {
        multiline: true,
        px: 4,
        py: 2,
        totalLines: 4,
        _ios: {
          h: 20
        }
      }
    },
    TextField: {
      defaultProps: {
        component: 'input'
      }
    },
    Toast: {
      defaultProps: {}
    },
    TypeAheadSearchItem: {},
    View: {
      baseStyle: {},
      defaultProps: {}
    },
    Wrap: {},
    ZStack: {
      baseStyle: {},
      defaultProps: {}
    },
    Tooltip: {}
  },
  config: {}
};
//# sourceMappingURL=index.js.map