import Coordinates from './Coordinates';
import { Shafaq } from './Shafaq';
import { ValueOf } from './TypeUtils';
declare const Astronomical: {
    meanSolarLongitude(julianCentury: number): number;
    meanLunarLongitude(julianCentury: number): number;
    ascendingLunarNodeLongitude(julianCentury: number): number;
    meanSolarAnomaly(julianCentury: number): number;
    solarEquationOfTheCenter(julianCentury: number, meanAnomaly: number): number;
    apparentSolarLongitude(julianCentury: number, meanLongitude: number): number;
    meanObliquityOfTheEcliptic(julianCentury: number): number;
    apparentObliquityOfTheEcliptic(julianCentury: number, meanObliquityOfTheEcliptic: number): number;
    meanSiderealTime(julianCentury: number): number;
    nutationInLongitude(julianCentury: number, solarLongitude: number, lunarLongitude: number, ascendingNode: number): number;
    nutationInObliquity(julianCentury: number, solarLongitude: number, lunarLongitude: number, ascendingNode: number): number;
    altitudeOfCelestialBody(observerLatitude: number, declination: number, localHourAngle: number): number;
    approximateTransit(longitude: number, siderealTime: number, rightAscension: number): number;
    correctedTransit(approximateTransit: number, longitude: number, siderealTime: number, rightAscension: number, previousRightAscension: number, nextRightAscension: number): number;
    correctedHourAngle(approximateTransit: number, angle: number, coordinates: Coordinates, afterTransit: boolean, siderealTime: number, rightAscension: number, previousRightAscension: number, nextRightAscension: number, declination: number, previousDeclination: number, nextDeclination: number): number;
    interpolate(y2: number, y1: number, y3: number, n: number): number;
    interpolateAngles(y2: number, y1: number, y3: number, n: number): number;
    julianDay(year: number, month: number, day: number, hours?: number): number;
    julianCentury(julianDay: number): number;
    isLeapYear(year: number): boolean;
    seasonAdjustedMorningTwilight(latitude: number, dayOfYear: number, year: number, sunrise: Date): Date;
    seasonAdjustedEveningTwilight(latitude: number, dayOfYear: number, year: number, sunset: Date, shafaq: ValueOf<typeof Shafaq>): Date;
    daysSinceSolstice(dayOfYear: number, year: number, latitude: number): number;
};
export default Astronomical;
