"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  attachEventHandlersOnRef: true,
  getLabel: true,
  isRTL: true,
  useId: true,
  useLayoutEffect: true,
  mergeIds: true,
  mergeProps: true,
  SSRProvider: true,
  useIsSSR: true
};
Object.defineProperty(exports, "useId", {
  enumerable: true,
  get: function () {
    return _utils.useId;
  }
});
Object.defineProperty(exports, "useLayoutEffect", {
  enumerable: true,
  get: function () {
    return _utils.useLayoutEffect;
  }
});
Object.defineProperty(exports, "mergeIds", {
  enumerable: true,
  get: function () {
    return _utils.mergeIds;
  }
});
Object.defineProperty(exports, "mergeProps", {
  enumerable: true,
  get: function () {
    return _utils.mergeProps;
  }
});
Object.defineProperty(exports, "SSRProvider", {
  enumerable: true,
  get: function () {
    return _ssr.SSRProvider;
  }
});
Object.defineProperty(exports, "useIsSSR", {
  enumerable: true,
  get: function () {
    return _ssr.useIsSSR;
  }
});
exports.isRTL = exports.getLabel = exports.attachEventHandlersOnRef = void 0;

var _reactNative = require("react-native");

var _ariaToAccessibilityMap = require("./ariaToAccessibilityMap");

Object.keys(_ariaToAccessibilityMap).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _ariaToAccessibilityMap[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _ariaToAccessibilityMap[key];
    }
  });
});

var _utils = require("@react-aria/utils");

var _ssr = require("@react-aria/ssr");

const attachEventHandlersOnRef = (props, ref) => {
  if (ref && ref.current) {
    for (let key in props) {
      if (key.startsWith('on')) {
        ref.current[key.toLowerCase()] = props[key];
      }
    }
  }
};

exports.attachEventHandlersOnRef = attachEventHandlersOnRef;

const getLabel = props => {
  let label = props['aria-label'];

  if (!label) {
    label = typeof props.label === 'string' ? props.label : undefined;
  }

  return label;
};

exports.getLabel = getLabel;

const isRTL = () => {
  // To support previous RN versions. Newer versions use below getConstants()
  if (_reactNative.I18nManager.isRTL !== undefined) {
    return _reactNative.I18nManager.isRTL;
  } // @ts-ignore - RN web only


  if (_reactNative.I18nManager.getConstants) {
    // @ts-ignore - RN web only
    return _reactNative.I18nManager.getConstants().isRTL;
  }
};

exports.isRTL = isRTL;
//# sourceMappingURL=index.js.map