import { usePress } from '@react-native-aria/interactions';
export function useTab(props, state, _ref) {
  let {
    item,
    isDisabled: propsDisabled
  } = props;
  let {
    key
  } = item;
  let {
    selectionManager: manager,
    selectedKey
  } = state;
  let isSelected = key === selectedKey;

  const onPress = () => {
    manager.select(key);
  };

  let isDisabled = propsDisabled || state.disabledKeys.has(key);
  let {
    pressProps
  } = usePress({
    onPress,
    isDisabled
  });
  const tabProps = { ...pressProps,
    accessibilityState: {
      selected: isSelected
    },
    accessibilityRole: 'tab'
  };
  return {
    tabProps
  };
}
//# sourceMappingURL=useTab.js.map