"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePanResponder = void 0;

var _reactNative = require("react-native");

const usePanResponder = props => {
  const _handleStartShouldSetPanResponder = () => {
    return true;
  };

  const _handleMoveShouldSetPanResponder = () => {
    return true;
  };

  const _handlePanResponderMove = (e, gestureState) => {
    props.onMove(e, gestureState);
  };

  const _handlePanResponderEnd = () => {
    props.onMoveEnd();
  };

  const _handlePanResponderGrant = () => {
    props.onMoveStart();
  };

  const panResponder = _reactNative.PanResponder.create({
    onStartShouldSetPanResponder: _handleStartShouldSetPanResponder,
    onMoveShouldSetPanResponder: _handleMoveShouldSetPanResponder,
    onPanResponderGrant: _handlePanResponderGrant,
    onPanResponderMove: _handlePanResponderMove,
    onPanResponderRelease: _handlePanResponderEnd,
    onPanResponderTerminate: _handlePanResponderEnd
  });

  return panResponder;
};

exports.usePanResponder = usePanResponder;
//# sourceMappingURL=usePanResponder.js.map