"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRadioGroup = useRadioGroup;

var _radio = require("@react-aria/radio");

var _utils = require("@react-aria/utils");

var _utils2 = require("@react-native-aria/utils");

/**
 * Provides the behavior and accessibility implementation for a radio group component.
 * Radio groups allow users to select a single item from a list of mutually exclusive options.
 * @param props - Props for the radio group.
 * @param state - State for the radio group, as returned by `useRadioGroupState`.
 */
function useRadioGroup(props, state) {
  const params = (0, _radio.useRadioGroup)(props, state);
  const newParams = {
    radioGroupProps: (0, _utils.mergeProps)(params.radioGroupProps, (0, _utils2.mapDomPropsToRN)(params.radioGroupProps)),
    labelProps: (0, _utils.mergeProps)(params.labelProps, (0, _utils2.mapDomPropsToRN)(params.labelProps))
  };
  return newParams;
}
//# sourceMappingURL=useRadioGroup.web.js.map