"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOption = useOption;

var _interactions = require("@react-native-aria/interactions");

/**
 * Provides the behavior and accessibility implementation for an option in a listbox.
 * See `useListBox` for more details about listboxes.
 * @param props - Props for the option.
 * @param state - State for the listbox, as returned by `useListState`.
 */
function useOption(props, state, _ref) {
  let {
    isSelected,
    isDisabled,
    key
  } = props;

  const onPress = () => {
    //@ts-ignore
    state.selectionManager.select(key);
  };

  let {
    pressProps
  } = (0, _interactions.usePress)({
    onPress,
    isDisabled
  });
  return {
    optionProps: { ...pressProps,
      'aria-selected': isSelected
    },
    labelProps: {},
    descriptionProps: {}
  };
}
//# sourceMappingURL=useOption.js.map