"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePress = usePress;

var _react = _interopRequireDefault(require("react"));

var _utils = require("@react-aria/utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function usePress({
  isDisabled,
  onPress,
  onPressStart,
  onPressEnd,
  onPressUp,
  // No onPressUp on RN.
  onPressChange,
  isPressed: isPressedProp,
  ...restProps
}) {
  let [isPressed, setPressed] = _react.default.useState(false);

  let pressProps = {
    onPress: e => {
      if (isDisabled) return;
      onPress && onPress(e);
    },
    onPressIn: e => {
      if (isDisabled) return;
      onPressStart && onPressStart(e);
      setPressed(true);
      onPressChange && onPressChange(true);
    },
    onPressOut: e => {
      if (isDisabled) return;
      onPressEnd && onPressEnd(e);
      setPressed(false);
      onPressChange && onPressChange(false);
      onPressUp && onPressUp(e);
    }
  };
  pressProps = (0, _utils.mergeProps)(pressProps, restProps);
  return {
    isPressed: isPressedProp || isPressed,
    pressProps
  };
}
//# sourceMappingURL=usePress.js.map