"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToggleButton = useToggleButton;

var _useButton = require("./useButton");

var _utils = require("@react-aria/utils");

function useToggleButton(props, state) {
  const {
    isSelected
  } = state;
  const {
    isPressed,
    buttonProps
  } = (0, _useButton.useButton)({ ...props,
    onPress: (0, _utils.chain)(state.toggle, props.onPress)
  });
  return {
    isPressed,
    buttonProps: (0, _utils.mergeProps)(buttonProps, {
      'aria-selected': isSelected
    })
  };
}
//# sourceMappingURL=useToggleButton.js.map