import React, { ComponentType, FunctionComponent } from 'react';
import { I18n } from '@lingui/core';

type TransRenderProps = {
    id?: string;
    translation?: React.ReactNode;
    children?: React.ReactNode;
    message?: string | null;
    isTranslated?: boolean;
};
type TransProps = {
    id: string;
    message?: string;
    values: Record<string, unknown>;
    context?: string;
    components: {
        [key: string]: React.ElementType | any;
    };
    formats?: Record<string, unknown>;
    children?: React.ReactNode;
    component?: React.ComponentType<TransRenderProps>;
    render?: (props: TransRenderProps) => React.ReactElement<any, any> | null;
};
declare function Trans(props: TransProps): React.ReactElement<any, any> | null;
declare namespace Trans {
    var defaultProps: {
        values: {};
        components: {};
    };
}

type I18nContext = {
    i18n: I18n;
    defaultComponent?: ComponentType<TransRenderProps>;
};
type withI18nProps = {
    i18n: I18n;
};
type I18nProviderProps = I18nContext & {
    forceRenderOnLocaleChange?: boolean;
    children?: React.ReactNode;
};
declare function useLingui(): I18nContext;
declare function withI18n(o?: object): <P extends withI18nProps>(Component: ComponentType<P>) => React.ComponentType<Omit<P, "i18n">>;
declare const I18nProvider: FunctionComponent<I18nProviderProps>;

export { I18nContext, I18nProvider, I18nProviderProps, Trans, TransProps, TransRenderProps, useLingui, withI18n, withI18nProps };
