"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = command;
var _chalk = _interopRequireDefault(require("chalk"));
var _commander = _interopRequireDefault(require("commander"));
var _conf = require("@lingui/conf");
var _catalog = require("./api/catalog");
var _detect = require("./api/detect");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
async function command(config, options) {
  // `react-app` babel plugin used by CRA requires either BABEL_ENV or NODE_ENV to be
  // set. We're setting it here, because lingui macros are going to use them as well.
  if (!process.env.BABEL_ENV && !process.env.NODE_ENV) {
    process.env.BABEL_ENV = "development";
  }

  // We need macros to keep imports, so extract-messages plugin know what componets
  // to collect. Users usually use both BABEN_ENV and NODE_ENV, so it's probably
  // safer to introduce a new env variable. LINGUI_EXTRACT=1 during `lingui extract`
  process.env.LINGUI_EXTRACT = "1";
  options.verbose && console.error("Extracting messages from source files…");
  const catalogs = (0, _catalog.getCatalogs)(config);
  const catalogStats = {};
  await Promise.all(catalogs.map(async catalog => {
    await catalog.makeTemplate({
      ...options,
      orderBy: config.orderBy,
      projectType: (0, _detect.detect)()
    });
    const catalogTemplate = catalog.readTemplate();
    if (catalogTemplate !== null && catalogTemplate !== undefined) {
      catalogStats[catalog.templateFile] = Object.keys(catalogTemplate).length;
    }
  }));
  Object.entries(catalogStats).forEach(([key, value]) => {
    console.log(`Catalog statistics for ${_chalk.default.bold(key)}: ${_chalk.default.green(value)} messages`);
    console.log();
  });
  return true;
}
if (require.main === module) {
  _commander.default.option("--config <path>", "Path to the config file").option("--verbose", "Verbose output").parse(process.argv);
  const config = (0, _conf.getConfig)({
    configPath: _commander.default.config || process.env.LINGUI_CONFIG
  });
  const result = command(config, {
    verbose: _commander.default.verbose || false,
    configPath: _commander.default.config || process.env.LINGUI_CONFIG
  }).then(() => {
    if (!result) process.exit(1);
  });
}