import { useRef, useState } from "react";
import { useControlledState } from "@react-stately/utils";
import { clamp, snapValueToStep } from "@react-aria/utils";
const $dcc38d2f5fc04b76254f325fa36d$var$DEFAULT_MIN_VALUE = 0;
const $dcc38d2f5fc04b76254f325fa36d$var$DEFAULT_MAX_VALUE = 100;
const $dcc38d2f5fc04b76254f325fa36d$var$DEFAULT_STEP_VALUE = 1;

/**
 * Provides state management for a slider component. Stores values for all thumbs,
 * formats values for localization, and provides methods to update the position
 * of any thumbs.
 * @param props
 */
export function useSliderState(props) {
  var _props$defaultValue;

  const {
    isDisabled,
    minValue = $dcc38d2f5fc04b76254f325fa36d$var$DEFAULT_MIN_VALUE,
    maxValue = $dcc38d2f5fc04b76254f325fa36d$var$DEFAULT_MAX_VALUE,
    numberFormatter: formatter,
    step = $dcc38d2f5fc04b76254f325fa36d$var$DEFAULT_STEP_VALUE
  } = props;
  const [values, setValues] = useControlledState(props.value, (_props$defaultValue = props.defaultValue) != null ? _props$defaultValue : [minValue], props.onChange);
  const [isDraggings, setDraggings] = useState(new Array(values.length).fill(false));
  const isEditablesRef = useRef(new Array(values.length).fill(true));
  const [focusedIndex, setFocusedIndex] = useState(undefined);
  const valuesRef = useRef(null);
  valuesRef.current = values;
  const isDraggingsRef = useRef(null);
  isDraggingsRef.current = isDraggings;

  function getValuePercent(value) {
    return (value - minValue) / (maxValue - minValue);
  }

  function getThumbMinValue(index) {
    return index === 0 ? minValue : values[index - 1];
  }

  function getThumbMaxValue(index) {
    return index === values.length - 1 ? maxValue : values[index + 1];
  }

  function isThumbEditable(index) {
    return isEditablesRef.current[index];
  }

  function setThumbEditable(index, editable) {
    isEditablesRef.current[index] = editable;
  }

  function updateValue(index, value) {
    if (isDisabled || !isThumbEditable(index)) {
      return;
    }

    const thisMin = getThumbMinValue(index);
    const thisMax = getThumbMaxValue(index); // Round value to multiple of step, clamp value between min and max

    value = snapValueToStep(value, thisMin, thisMax, step);
    valuesRef.current = $dcc38d2f5fc04b76254f325fa36d$var$replaceIndex(valuesRef.current, index, value);
    setValues(valuesRef.current);
  }

  function updateDragging(index, dragging) {
    if (isDisabled || !isThumbEditable(index)) {
      return;
    }

    const wasDragging = isDraggingsRef.current[index];
    isDraggingsRef.current = $dcc38d2f5fc04b76254f325fa36d$var$replaceIndex(isDraggingsRef.current, index, dragging);
    setDraggings(isDraggingsRef.current); // Call onChangeEnd if no handles are dragging.

    if (props.onChangeEnd && wasDragging && !isDraggingsRef.current.some(Boolean)) {
      props.onChangeEnd(valuesRef.current);
    }
  }

  function getFormattedValue(value) {
    return formatter.format(value);
  }

  function setThumbPercent(index, percent) {
    updateValue(index, getPercentValue(percent));
  }

  function getRoundedValue(value) {
    return Math.round((value - minValue) / step) * step + minValue;
  }

  function getPercentValue(percent) {
    const val = percent * (maxValue - minValue) + minValue;
    return clamp(getRoundedValue(val), minValue, maxValue);
  }

  return {
    values: values,
    getThumbValue: index => values[index],
    setThumbValue: updateValue,
    setThumbPercent,
    isThumbDragging: index => isDraggings[index],
    setThumbDragging: updateDragging,
    focusedThumb: focusedIndex,
    setFocusedThumb: setFocusedIndex,
    getThumbPercent: index => getValuePercent(values[index]),
    getValuePercent,
    getThumbValueLabel: index => getFormattedValue(values[index]),
    getFormattedValue,
    getThumbMinValue,
    getThumbMaxValue,
    getPercentValue,
    isThumbEditable,
    setThumbEditable,
    step
  };
}

function $dcc38d2f5fc04b76254f325fa36d$var$replaceIndex(array, index, value) {
  if (array[index] === value) {
    return array;
  }

  return [...array.slice(0, index), value, ...array.slice(index + 1)];
}
//# sourceMappingURL=module.js.map
