var {
  useRef,
  useState
} = require("react");

var {
  useControlledState
} = require("@react-stately/utils");

var {
  clamp,
  snapValueToStep
} = require("@react-aria/utils");

const $bc3294032743285adead374b6f67$var$DEFAULT_MIN_VALUE = 0;
const $bc3294032743285adead374b6f67$var$DEFAULT_MAX_VALUE = 100;
const $bc3294032743285adead374b6f67$var$DEFAULT_STEP_VALUE = 1;

/**
 * Provides state management for a slider component. Stores values for all thumbs,
 * formats values for localization, and provides methods to update the position
 * of any thumbs.
 * @param props
 */
function useSliderState(props) {
  var _props$defaultValue;

  const {
    isDisabled,
    minValue = $bc3294032743285adead374b6f67$var$DEFAULT_MIN_VALUE,
    maxValue = $bc3294032743285adead374b6f67$var$DEFAULT_MAX_VALUE,
    numberFormatter: formatter,
    step = $bc3294032743285adead374b6f67$var$DEFAULT_STEP_VALUE
  } = props;
  const [values, setValues] = useControlledState(props.value, (_props$defaultValue = props.defaultValue) != null ? _props$defaultValue : [minValue], props.onChange);
  const [isDraggings, setDraggings] = useState(new Array(values.length).fill(false));
  const isEditablesRef = useRef(new Array(values.length).fill(true));
  const [focusedIndex, setFocusedIndex] = useState(undefined);
  const valuesRef = useRef(null);
  valuesRef.current = values;
  const isDraggingsRef = useRef(null);
  isDraggingsRef.current = isDraggings;

  function getValuePercent(value) {
    return (value - minValue) / (maxValue - minValue);
  }

  function getThumbMinValue(index) {
    return index === 0 ? minValue : values[index - 1];
  }

  function getThumbMaxValue(index) {
    return index === values.length - 1 ? maxValue : values[index + 1];
  }

  function isThumbEditable(index) {
    return isEditablesRef.current[index];
  }

  function setThumbEditable(index, editable) {
    isEditablesRef.current[index] = editable;
  }

  function updateValue(index, value) {
    if (isDisabled || !isThumbEditable(index)) {
      return;
    }

    const thisMin = getThumbMinValue(index);
    const thisMax = getThumbMaxValue(index); // Round value to multiple of step, clamp value between min and max

    value = snapValueToStep(value, thisMin, thisMax, step);
    valuesRef.current = $bc3294032743285adead374b6f67$var$replaceIndex(valuesRef.current, index, value);
    setValues(valuesRef.current);
  }

  function updateDragging(index, dragging) {
    if (isDisabled || !isThumbEditable(index)) {
      return;
    }

    const wasDragging = isDraggingsRef.current[index];
    isDraggingsRef.current = $bc3294032743285adead374b6f67$var$replaceIndex(isDraggingsRef.current, index, dragging);
    setDraggings(isDraggingsRef.current); // Call onChangeEnd if no handles are dragging.

    if (props.onChangeEnd && wasDragging && !isDraggingsRef.current.some(Boolean)) {
      props.onChangeEnd(valuesRef.current);
    }
  }

  function getFormattedValue(value) {
    return formatter.format(value);
  }

  function setThumbPercent(index, percent) {
    updateValue(index, getPercentValue(percent));
  }

  function getRoundedValue(value) {
    return Math.round((value - minValue) / step) * step + minValue;
  }

  function getPercentValue(percent) {
    const val = percent * (maxValue - minValue) + minValue;
    return clamp(getRoundedValue(val), minValue, maxValue);
  }

  return {
    values: values,
    getThumbValue: index => values[index],
    setThumbValue: updateValue,
    setThumbPercent,
    isThumbDragging: index => isDraggings[index],
    setThumbDragging: updateDragging,
    focusedThumb: focusedIndex,
    setFocusedThumb: setFocusedIndex,
    getThumbPercent: index => getValuePercent(values[index]),
    getValuePercent,
    getThumbValueLabel: index => getFormattedValue(values[index]),
    getFormattedValue,
    getThumbMinValue,
    getThumbMaxValue,
    getPercentValue,
    isThumbEditable,
    setThumbEditable,
    step
  };
}

exports.useSliderState = useSliderState;

function $bc3294032743285adead374b6f67$var$replaceIndex(array, index, value) {
  if (array[index] === value) {
    return array;
  }

  return [...array.slice(0, index), value, ...array.slice(index + 1)];
}
//# sourceMappingURL=main.js.map
