"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timeout = exports.promisify = exports.promise = exports.sleep = exports.defer = void 0;
function defer(timeout, tag, keepalive) {
    const futureResolvable = {};
    const promise = new Promise((resolve, reject) => {
        futureResolvable.resolve = (v) => {
            resolve(v);
        };
        futureResolvable.reject = (e) => {
            reject(e);
        };
    });
    const resolvable = futureResolvable;
    if (timeout) {
        let timer = setTimeout(() => {
            timer = null;
            const error = new Error('timeout');
            // @ts-ignore
            error.code = 'ETIMEDOUT';
            resolvable.reject(error);
        }, +timeout);
        const cancel = () => {
            if (timer) {
                clearTimeout(timer);
            }
            timer = null;
        };
        if (!keepalive)
            timer.unref();
        resolvable.resolve = hookedResolve.bind(null, resolvable.resolve, cancel);
        resolvable.reject = hookedReject.bind(null, resolvable.reject, cancel);
    }
    promise.resolve = resolvable.resolve;
    promise.reject = resolvable.reject;
    promise.promise = promise;
    promise.callback = resolvableCallback.bind(null, resolvable.resolve, resolvable.reject);
    promise.tag = tag;
    return promise;
}
exports.defer = defer;
function resolvableCallback(resolve, reject, error, value) {
    if (error) {
        reject(error);
    }
    else if (value !== undefined) {
        resolve(value);
    }
    else {
        reject(new Error('invalid invocation'));
    }
}
function hookedResolve(resolve, hook, value) {
    hook();
    resolve(value);
}
function hookedReject(reject, hook, reason) {
    hook();
    reject(reason);
}
function sleep(ms) {
    return new Promise((resolve) => {
        setTimeout(resolve, +ms);
    });
}
exports.sleep = sleep;
async function promise(func, ...args) {
    const deferred = defer();
    try {
        func(...args, deferred.callback);
    }
    catch (err) {
        deferred.reject(err);
    }
    return deferred;
}
exports.promise = promise;
function promisify(func) {
    return (...args) => promise(func, ...args);
}
exports.promisify = promisify;
function timeout(future, timeout, keepalive = false) {
    const deferred = defer(timeout, undefined, keepalive);
    if ('then' in future && 'function' === typeof future.then) {
        future.then(deferred.resolve, deferred.reject);
    }
    else {
        Promise.resolve()
            .then(() => future())
            .then(deferred.resolve, deferred.reject);
    }
    return deferred;
}
exports.timeout = timeout;
const Default = Object.freeze({
    defer,
    sleep,
    promise,
    promisify,
    timeout,
});
exports.default = Default;
