import { useEffect } from "react";
import { useSingleSelectListState } from "@react-stately/list";
export function useTabsState(props) {
  let state = useSingleSelectListState(props);
  useEffect(() => {
    // Ensure a tab is always selected (in case no selected key was specified or if selected item was deleted from collection)
    if (state.selectionManager.isEmpty || !state.collection.getItem(state.selectedKey)) {
      state.selectionManager.replaceSelection(state.collection.getFirstKey());
    }
  }, [state.selectionManager, state.selectedKey, state.collection]);
  return state;
}
//# sourceMappingURL=module.js.map
