"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTab = useTab;

var _interactions = require("@react-native-aria/interactions");

function useTab(props, state, _ref) {
  let {
    item,
    isDisabled: propsDisabled
  } = props;
  let {
    key
  } = item;
  let {
    selectionManager: manager,
    selectedKey
  } = state;
  let isSelected = key === selectedKey;

  const onPress = () => {
    manager.select(key);
  };

  let isDisabled = propsDisabled || state.disabledKeys.has(key);
  let {
    pressProps
  } = (0, _interactions.usePress)({
    onPress,
    isDisabled
  });
  const tabProps = { ...pressProps,
    accessibilityState: {
      selected: isSelected
    },
    accessibilityRole: 'tab'
  };
  return {
    tabProps
  };
}
//# sourceMappingURL=useTab.js.map