import { AriaSliderThumbProps } from '@react-types/slider';
import { SliderState } from '@react-stately/slider';
interface SliderThumbAria {
    /** Props for the root thumb element; handles the dragging motion. */
    thumbProps: any;
    /** Props for the visually hidden range input element. */
    inputProps: any;
    /** Props for the label element for this thumb (optional). */
    labelProps: any;
}
interface SliderThumbOptions extends AriaSliderThumbProps {
    /** A ref to the track element. */
    trackLayout: any;
    /** A ref to the thumb input element. */
    inputRef: any;
}
/**
 * Provides behavior and accessibility for a thumb of a slider component.
 *
 * @param opts Options for this Slider thumb.
 * @param state Slider state, created via `useSliderState`.
 */
export declare function useSliderThumb(opts: SliderThumbOptions, state: SliderState, isReversed?: boolean): SliderThumbAria;
export {};
