"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMove = useMove;

var _react = _interopRequireWildcard(require("react"));

var _reactNative = require("react-native");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/**
 * Handles move interactions across mouse, touch, and keyboard, including dragging with
 * the mouse or touch, and using the arrow keys. Normalizes behavior across browsers and
 * platforms, and ignores emulated mouse events on touch devices.
 */
function useMove(props) {
  let {
    onMoveStart,
    onMove,
    onMoveEnd
  } = props;
  const [initialMoveX, setInitialMoveX] = (0, _react.useState)(0);
  const [initialMoveY, setInitialMoveY] = (0, _react.useState)(0);

  const panResponder = _react.default.useMemo(() => _reactNative.PanResponder.create({
    onMoveShouldSetPanResponderCapture: _event => {
      return true;
    },
    onPanResponderGrant: (_evt, gestureState) => {
      onMoveStart === null || onMoveStart === void 0 ? void 0 : onMoveStart({
        type: 'movestart',
        pointerType: 'touch'
      });
      setInitialMoveX(gestureState.moveX);
      setInitialMoveY(gestureState.moveY);
    },
    onPanResponderMove: (_event, gestureState) => {
      const deltaX = gestureState.moveX - initialMoveX;
      const deltaY = gestureState.moveY - initialMoveY;

      if (deltaX === 0 && deltaY === 0) {
        return;
      }

      if (deltaX) {
        onMove({
          type: 'move',
          pointerType: 'touch',
          deltaX: deltaX,
          deltaY: deltaY
        });
      }
    },
    onPanResponderRelease: () => {
      onMoveEnd === null || onMoveEnd === void 0 ? void 0 : onMoveEnd({
        type: 'moveend',
        pointerType: 'touch'
      });
    }
  }), [onMove, onMoveEnd, onMoveStart, initialMoveX, initialMoveY]);

  return {
    moveProps: panResponder.panHandlers
  };
}
//# sourceMappingURL=useMove.js.map