import { Placement, PlacementAxis } from '@react-types/overlays';
interface Position {
    top?: number;
    left?: number;
    bottom?: number;
    right?: number;
}
interface Dimensions {
    width: number;
    height: number;
    top: number;
    left: number;
    scroll: Position;
}
interface Offset {
    top: number;
    left: number;
    width: number;
    height: number;
}
interface PositionOpts {
    placement: Placement;
    targetNode: HTMLElement;
    overlayNode: HTMLElement;
    scrollNode: HTMLElement;
    padding: number;
    shouldFlip: boolean;
    boundaryElement: HTMLElement;
    offset: number;
    crossOffset: number;
    shouldOverlapWithTrigger: boolean;
}
export interface PositionResult {
    position?: Position;
    arrowOffsetLeft?: number;
    arrowOffsetTop?: number;
    maxHeight?: number;
    placement: PlacementAxis;
}
export declare function calculatePositionInternal(placementInput: Placement, childOffset: Offset, overlaySize: Offset, scrollSize: Offset, margins: Position, padding: number, flip: boolean, boundaryDimensions: Dimensions, containerOffsetWithBoundary: Offset, offset: number, crossOffset: number, isContainerPositioned: boolean, shouldOverlapWithTrigger: boolean): PositionResult;
/**
 * Determines where to place the overlay with regards to the target and the position of an optional indicator.
 */
export declare function calculatePosition(opts: PositionOpts): PositionResult;
export {};
//# sourceMappingURL=calculatePosition.d.ts.map