import type { AriaCheckboxGroupItemProps } from '@react-types/checkbox';
import { CheckboxAria } from './useCheckbox';
import type { CheckboxGroupState } from '@react-stately/checkbox';
import type { RefObject } from 'react';
/**
 * Provides the behavior and accessibility implementation for a checkbox component contained within a checkbox group.
 * Checkbox groups allow users to select multiple items from a list of options.
 * @param props - Props for the checkbox.
 * @param state - State for the checkbox, as returned by `useCheckboxGroupState`.
 * @param inputRef - A ref for the HTML input element.
 */
export declare function useCheckboxGroupItem(props: AriaCheckboxGroupItemProps, state: CheckboxGroupState, inputRef: RefObject<any>): CheckboxAria;
//# sourceMappingURL=useCheckboxGroupItem.d.ts.map