var {
  useEffect
} = require("react");

var {
  useSingleSelectListState
} = require("@react-stately/list");

function useTabsState(props) {
  let state = useSingleSelectListState(props);
  useEffect(() => {
    // Ensure a tab is always selected (in case no selected key was specified or if selected item was deleted from collection)
    if (state.selectionManager.isEmpty || !state.collection.getItem(state.selectedKey)) {
      state.selectionManager.replaceSelection(state.collection.getFirstKey());
    }
  }, [state.selectionManager, state.selectedKey, state.collection]);
  return state;
}

exports.useTabsState = useTabsState;
//# sourceMappingURL=main.js.map
