import { useSelectableCollection, useSelectableItem } from "@react-aria/selection";
import { usePress } from "@react-aria/interactions";
import { useLocale } from "@react-aria/i18n";
import { mergeProps, useId, useLabels } from "@react-aria/utils";
import { useMemo } from "react";
import _babelRuntimeHelpersEsmExtends from "@babel/runtime/helpers/esm/extends";

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
class $ace72fda23df319bd9db38f00073d9$export$TabsKeyboardDelegate {
  constructor(collection, direction, orientation, disabledKeys) {
    if (disabledKeys === void 0) {
      disabledKeys = new Set();
    }

    this.collection = void 0;
    this.flipDirection = void 0;
    this.disabledKeys = void 0;
    this.orientation = void 0;
    this.collection = collection;
    this.flipDirection = direction === 'rtl' && orientation === 'horizontal';
    this.orientation = orientation;
    this.disabledKeys = disabledKeys;
  }

  getKeyLeftOf(key) {
    if (this.flipDirection) {
      return this.getNextKey(key);
    } else {
      if (this.orientation === 'horizontal') {
        return this.getPreviousKey(key);
      }

      return null;
    }
  }

  getKeyRightOf(key) {
    if (this.flipDirection) {
      return this.getPreviousKey(key);
    } else {
      if (this.orientation === 'horizontal') {
        return this.getNextKey(key);
      }

      return null;
    }
  }

  getKeyAbove(key) {
    if (this.orientation === 'vertical') {
      return this.getPreviousKey(key);
    }

    return null;
  }

  getKeyBelow(key) {
    if (this.orientation === 'vertical') {
      return this.getNextKey(key);
    }

    return null;
  }

  getFirstKey() {
    let key = this.collection.getFirstKey();

    if (this.disabledKeys.has(key)) {
      key = this.getNextKey(key);
    }

    return key;
  }

  getLastKey() {
    let key = this.collection.getLastKey();

    if (this.disabledKeys.has(key)) {
      key = this.getPreviousKey(key);
    }

    return key;
  }

  getNextKey(key) {
    do {
      key = this.collection.getKeyAfter(key);

      if (key == null) {
        key = this.collection.getFirstKey();
      }
    } while (this.disabledKeys.has(key));

    return key;
  }

  getPreviousKey(key) {
    do {
      key = this.collection.getKeyBefore(key);

      if (key == null) {
        key = this.collection.getLastKey();
      }
    } while (this.disabledKeys.has(key));

    return key;
  }

}

const $a98339edf5b490c874cb7f3b44b70$var$tabsIds = new WeakMap();
export function useTabs(props, state, ref) {
  let {
    orientation = 'horizontal',
    keyboardActivation = 'automatic'
  } = props;
  let {
    collection,
    selectionManager: manager,
    disabledKeys,
    selectedKey
  } = state;
  let {
    direction
  } = useLocale();
  let delegate = useMemo(() => new $ace72fda23df319bd9db38f00073d9$export$TabsKeyboardDelegate(collection, direction, orientation, disabledKeys), [collection, disabledKeys, orientation, direction]);
  let {
    collectionProps
  } = useSelectableCollection({
    ref,
    selectionManager: manager,
    keyboardDelegate: delegate,
    selectOnFocus: keyboardActivation === 'automatic',
    disallowEmptySelection: true
  }); // Compute base id for all tabs

  let tabsId = useId();
  $a98339edf5b490c874cb7f3b44b70$var$tabsIds.set(state, tabsId);
  let tabListLabelProps = useLabels(_babelRuntimeHelpersEsmExtends({}, props, {
    id: tabsId
  }));
  return {
    tabListProps: _babelRuntimeHelpersEsmExtends({}, mergeProps(collectionProps, tabListLabelProps), {
      role: 'tablist',
      'aria-orientation': orientation,
      tabIndex: undefined
    }),
    tabPanelProps: {
      id: $a98339edf5b490c874cb7f3b44b70$var$generateId(state, selectedKey, 'tabpanel'),
      'aria-labelledby': $a98339edf5b490c874cb7f3b44b70$var$generateId(state, selectedKey, 'tab'),
      tabIndex: 0,
      role: 'tabpanel'
    }
  };
}
export function useTab(props, state, ref) {
  let {
    item,
    isDisabled: propsDisabled
  } = props;
  let {
    key
  } = item;
  let {
    selectionManager: manager,
    selectedKey
  } = state;
  let isSelected = key === selectedKey;
  let {
    itemProps
  } = useSelectableItem({
    selectionManager: manager,
    key,
    ref
  });
  let isDisabled = propsDisabled || state.disabledKeys.has(key);
  let {
    pressProps
  } = usePress(_babelRuntimeHelpersEsmExtends({}, itemProps, {
    isDisabled
  }));
  let tabId = $a98339edf5b490c874cb7f3b44b70$var$generateId(state, key, 'tab');
  let tabPanelId = $a98339edf5b490c874cb7f3b44b70$var$generateId(state, key, 'tabpanel');
  let {
    tabIndex
  } = pressProps; // selected tab should have tabIndex=0, when it initializes

  if (isSelected && !isDisabled) {
    tabIndex = 0;
  }

  return {
    tabProps: _babelRuntimeHelpersEsmExtends({}, pressProps, {
      id: tabId,
      'aria-selected': isSelected,
      'aria-disabled': isDisabled || undefined,
      'aria-controls': isSelected ? tabPanelId : undefined,
      tabIndex: isDisabled ? undefined : tabIndex,
      role: 'tab'
    })
  };
}

function $a98339edf5b490c874cb7f3b44b70$var$generateId(state, key, role) {
  if (typeof key === 'string') {
    key = key.replace(/\s+/g, '');
  }

  let baseId = $a98339edf5b490c874cb7f3b44b70$var$tabsIds.get(state);
  return baseId + "-" + role + "-" + key;
}
//# sourceMappingURL=module.js.map
