"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = command;
var _chalk = _interopRequireDefault(require("chalk"));
var _chokidar = _interopRequireDefault(require("chokidar"));
var _commander = _interopRequireDefault(require("commander"));
var _conf = require("@lingui/conf");
var _catalog = require("./api/catalog");
var _stats = require("./api/stats");
var _detect = require("./api/detect");
var _help = require("./api/help");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
async function command(config, options) {
  // `react-app` babel plugin used by CRA requires either BABEL_ENV or NODE_ENV to be
  // set. We're setting it here, because lingui macros are going to use them as well.
  if (!process.env.BABEL_ENV && !process.env.NODE_ENV) {
    process.env.BABEL_ENV = "development";
  }

  // We need macros to keep imports, so extract-messages plugin know what componets
  // to collect. Users usually use both BABEN_ENV and NODE_ENV, so it's probably
  // safer to introduce a new env variable. LINGUI_EXTRACT=1 during `lingui extract`
  process.env.LINGUI_EXTRACT = "1";
  options.verbose && console.error("Extracting messages from source files…");
  const catalogs = (0, _catalog.getCatalogs)(config);
  const catalogStats = {};
  let commandSuccess = true;
  for (let catalog of catalogs) {
    const catalogSuccess = await catalog.make({
      ...options,
      orderBy: config.orderBy,
      extractors: config.extractors,
      projectType: (0, _detect.detect)()
    });
    catalogStats[catalog.path] = catalog.readAll();
    commandSuccess && (commandSuccess = catalogSuccess);
  }
  Object.entries(catalogStats).forEach(([key, value]) => {
    console.log(`Catalog statistics for ${key}: `);
    console.log((0, _stats.printStats)(config, value).toString());
    console.log();
  });
  if (!options.watch) {
    console.error(`(use "${_chalk.default.yellow((0, _help.helpRun)("extract"))}" to update catalogs with new messages)`);
    console.error(`(use "${_chalk.default.yellow((0, _help.helpRun)("compile"))}" to compile catalogs for production)`);
  }

  // If service key is present in configuration, synchronize with cloud translation platform
  if (typeof config.service === "object" && config.service.name && config.service.name.length) {
    const moduleName = config.service.name.charAt(0).toLowerCase() + config.service.name.slice(1);
    (specifier => new Promise(r => r(specifier)).then(s => _interopRequireWildcard(require(s))))(`./services/${moduleName}`).then(module => module.default(config, options)).catch(err => console.error(`Can't load service module ${moduleName}`, err));
  }
  return commandSuccess;
}
if (require.main === module) {
  _commander.default.option("--config <path>", "Path to the config file").option("--locale <locale>", "Only extract the specified locale").option("--overwrite", "Overwrite translations for source locale").option("--clean", "Remove obsolete translations").option("--debounce <delay>", "Debounces extraction for given amount of milliseconds").option("--verbose", "Verbose output").option("--convert-from <format>", "Convert from previous format of message catalogs").option("--watch", "Enables Watch Mode")
  // Obsolete options
  .option("--babelOptions", "Babel options passed to transform/extract plugins").option("--format <format>", "Format of message catalogs").parse(process.argv);
  const config = (0, _conf.getConfig)({
    configPath: _commander.default.config || process.env.LINGUI_CONFIG
  });
  let hasErrors = false;
  if (_commander.default.format) {
    hasErrors = true;
    const msg = "--format option is deprecated." + " Please set format in configuration https://lingui.dev/ref/conf#format";
    console.error(msg);
    console.error();
  }
  if (_commander.default.babelOptions) {
    hasErrors = true;
    const msg = "--babelOptions option is deprecated." + " Please set extractBabelOptions in configuration https://lingui.dev/ref/conf#extractbabeloptions";
    console.error(msg);
    console.error();
  }
  const prevFormat = _commander.default.convertFrom;
  if (prevFormat && config.format === prevFormat) {
    hasErrors = true;
    console.error("Trying to migrate message catalog to the same format");
    console.error(`Set ${_chalk.default.bold("new")} format in LinguiJS configuration\n` + ` and ${_chalk.default.bold("previous")} format using --convert-from option.`);
    console.log();
    console.log(`Example: Convert from lingui format to minimal`);
    console.log(_chalk.default.yellow((0, _help.helpRun)(`extract --convert-from lingui`)));
    process.exit(1);
  }
  if (_commander.default.locale && !config.locales.includes(_commander.default.locale)) {
    hasErrors = true;
    console.error(`Locale ${_chalk.default.bold(_commander.default.locale)} does not exist.`);
    console.error();
  }
  if (hasErrors) process.exit(1);
  const extract = filePath => {
    return command(config, {
      verbose: _commander.default.watch || _commander.default.verbose || false,
      clean: _commander.default.watch ? false : _commander.default.clean || false,
      overwrite: _commander.default.watch || _commander.default.overwrite || false,
      locale: _commander.default.locale,
      configPath: _commander.default.config || process.env.LINGUI_CONFIG,
      watch: _commander.default.watch || false,
      files: filePath !== null && filePath !== void 0 && filePath.length ? filePath : undefined,
      prevFormat
    });
  };
  const changedPaths = new Set();
  let debounceTimer;
  let previousExtract = Promise.resolve(true);
  const dispatchExtract = filePath => {
    // Skip debouncing if not enabled but still chain them so no racing issue
    // on deleting the tmp folder.
    if (!_commander.default.debounce) {
      previousExtract = previousExtract.then(() => extract(filePath));
      return previousExtract;
    }
    filePath === null || filePath === void 0 ? void 0 : filePath.forEach(path => changedPaths.add(path));

    // CLear the previous timer if there is any, and schedule the next
    debounceTimer && clearTimeout(debounceTimer);
    debounceTimer = setTimeout(async () => {
      const filePath = [...changedPaths];
      changedPaths.clear();
      await extract(filePath);
    }, _commander.default.debounce);
  };

  // Check if Watch Mode is enabled
  if (_commander.default.watch) {
    console.info(_chalk.default.bold("Initializing Watch Mode..."));
    const catalogs = (0, _catalog.getCatalogs)(config);
    let paths = [];
    let ignored = [];
    catalogs.forEach(catalog => {
      paths.push(...catalog.include);
      ignored.push(...catalog.exclude);
    });
    const watcher = _chokidar.default.watch(paths, {
      ignored: ["/(^|[/\\])../", ...ignored],
      persistent: true
    });
    const onReady = () => {
      console.info(_chalk.default.green.bold("Watcher is ready!"));
      watcher.on("add", path => dispatchExtract([path])).on("change", path => dispatchExtract([path]));
    };
    watcher.on("ready", () => onReady());
  } else if (_commander.default.args) {
    // this behaviour occurs when we extract files by his name
    // for ex: lingui extract src/app, this will extract only files included in src/app
    extract(_commander.default.args).then(result => {
      if (!result) process.exit(1);
    });
  } else {
    extract().then(result => {
      if (!result) process.exit(1);
    });
  }
}