// language codes: https://www.unicode.org/cldr/charts/43/supplemental/language_plural_rules.html

module.exports = {
  catalogs: [
    {
      path: '<rootDir>/locales/{locale}/messages',
      include: [
        '<rootDir>/src',
        '<rootDir>/website/src',
        '<rootDir>/fastlane/update/',
      ],
      exclude: ['**/node_modules/**'],
    },
  ],
  locales: ['en', 'fa', 'ar', 'tr', 'id', 'fr', 'ur', 'hi', 'de', 'bs', 'vi', 'bn', 'sw'],
  sourceLocale: 'en',
  format: 'po',
  fallbackLocales: {
    default: 'en',
  },
  compileNamespace: 'ts',
  service: {
    name: 'TranslationIO',
    apiKey: '',
  },
};
