var {
  useMemo,
  useState
} = require("react");

var {
  useControlledState
} = require("@react-stately/utils");

let $d0ad1e5f2b737cb6c44a515e014bc7c0$var$instance = Math.round(Math.random() * 10000000000);
let $d0ad1e5f2b737cb6c44a515e014bc7c0$var$i = 0;
/**
 * Provides state management for a radio group component. Provides a name for the group,
 * and manages selection and focus state.
 */

function useRadioGroupState(props) {
  // Preserved here for backward compatibility. React Aria now generates the name instead of stately.
  let name = useMemo(() => props.name || "radio-group-" + $d0ad1e5f2b737cb6c44a515e014bc7c0$var$instance + "-" + ++$d0ad1e5f2b737cb6c44a515e014bc7c0$var$i, [props.name]);
  let [selectedValue, setSelected] = useControlledState(props.value, props.defaultValue, props.onChange);
  let [lastFocusedValue, setLastFocusedValue] = useState(null);

  let setSelectedValue = value => {
    if (!props.isReadOnly) {
      setSelected(value);
    }
  };

  return {
    name,
    selectedValue,
    setSelectedValue,
    lastFocusedValue,
    setLastFocusedValue
  };
}

exports.useRadioGroupState = useRadioGroupState;
//# sourceMappingURL=main.js.map
