export declare const AlertDialog: {
    baseStyle: {
        width: string;
        height: string;
        justifyContent: string;
        alignItems: string;
        _web: {
            pointerEvents: string;
        };
        _backdropFade: {
            exitDuration: number;
            entryDuration: number;
        };
        _fade: {
            exitDuration: number;
            entryDuration: number;
        };
        _slide: {
            duration: number;
            overlay: boolean;
        };
        _overlay: {
            unmountOnExit: boolean;
        };
    };
    sizes: {
        xs: {
            contentSize: {
                width: string;
                maxWidth: string;
            };
        };
        sm: {
            contentSize: {
                width: string;
                maxWidth: string;
            };
        };
        md: {
            contentSize: {
                width: string;
                maxWidth: string;
            };
        };
        lg: {
            contentSize: {
                width: string;
                maxWidth: string;
            };
        };
        xl: {
            contentSize: {
                width: string;
                maxWidth: string;
            };
        };
        full: {
            contentSize: {
                width: string;
            };
        };
    };
    defaultProps: {
        size: string;
        closeOnOverlayClick: boolean;
    };
};
export declare const AlertDialogContent: {
    baseStyle: () => {
        shadow: number;
        rounded: string;
        maxHeight: string;
        overflow: string;
        bg: string;
        _text: {
            color: string;
        };
        _dark: {
            bg: string;
            color: string;
        };
    };
};
export declare const AlertDialogCloseButton: {
    baseStyle: () => {
        position: string;
        right: string;
        top: string;
        zIndex: string;
        p: string;
        bg: string;
        borderRadius: string;
        _web: {
            outlineWidth: number;
            cursor: string;
        };
        _icon: {
            size: string;
            color: string;
        };
        _hover: {
            bg: string;
        };
        _pressed: {
            bg: string;
        };
        _dark: {
            _icon: {
                color: string;
            };
            _hover: {
                bg: string;
            };
            _pressed: {
                bg: string;
            };
        };
    };
};
export declare const AlertDialogHeader: {
    baseStyle: () => {
        p: string;
        borderBottomWidth: string;
        _text: {
            color: string;
            fontSize: string;
            fontWeight: string;
            lineHeight: string;
        };
        bg: string;
        borderColor: string;
        _dark: {
            bg: string;
            borderColor: string;
            _text: {
                color: string;
            };
        };
    };
};
export declare const AlertDialogBody: {
    baseStyle: () => {
        p: string;
        bg: string;
        _text: {
            color: string;
        };
        _dark: {
            bg: string;
            _text: {
                color: string;
            };
        };
    };
};
export declare const AlertDialogFooter: {
    baseStyle: () => {
        p: string;
        flexDirection: string;
        justifyContent: string;
        flexWrap: string;
        borderTopWidth: string;
        bg: string;
        borderColor: string;
        _dark: {
            bg: string;
            borderColor: string;
        };
    };
};
export declare const AlertDialogOverlay: {
    baseStyle: {
        position: string;
        left: string;
        top: string;
        opacity: string;
        right: string;
        bottom: string;
    };
};
