import {useOverlayTriggerState as $9Xvoh$useOverlayTriggerState} from "@react-stately/overlays";
import {useState as $9Xvoh$useState, useMemo as $9Xvoh$useMemo, useCallback as $9Xvoh$useCallback} from "react";

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ /*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 

function $a28c903ee9ad8dc5$export$79fefeb1c2091ac3(props) {
    let overlayTriggerState = (0, $9Xvoh$useOverlayTriggerState)(props);
    let [focusStrategy, setFocusStrategy] = (0, $9Xvoh$useState)(null);
    let [expandedKeysStack, setExpandedKeysStack] = (0, $9Xvoh$useState)([]);
    let closeAll = ()=>{
        setExpandedKeysStack([]);
        overlayTriggerState.close();
    };
    let openSubmenu = (triggerKey, level)=>{
        setExpandedKeysStack((oldStack)=>{
            if (level > oldStack.length) return oldStack;
            return [
                ...oldStack.slice(0, level),
                triggerKey
            ];
        });
    };
    let closeSubmenu = (triggerKey, level)=>{
        setExpandedKeysStack((oldStack)=>{
            let key = oldStack[level];
            if (key === triggerKey) return oldStack.slice(0, level);
            else return oldStack;
        });
    };
    return {
        focusStrategy: focusStrategy,
        ...overlayTriggerState,
        open (focusStrategy = null) {
            setFocusStrategy(focusStrategy);
            overlayTriggerState.open();
        },
        toggle (focusStrategy = null) {
            setFocusStrategy(focusStrategy);
            overlayTriggerState.toggle();
        },
        close () {
            closeAll();
        },
        UNSTABLE_expandedKeysStack: expandedKeysStack,
        UNSTABLE_openSubmenu: openSubmenu,
        UNSTABLE_closeSubmenu: closeSubmenu
    };
}


/*
 * Copyright 2023 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 
function $e5614764aa47eb35$export$d39fdbfa42246ac4(props, state) {
    let { triggerKey: triggerKey } = props;
    let { UNSTABLE_expandedKeysStack: UNSTABLE_expandedKeysStack, UNSTABLE_openSubmenu: UNSTABLE_openSubmenu, UNSTABLE_closeSubmenu: UNSTABLE_closeSubmenu, close: closeAll } = state;
    let [submenuLevel] = (0, $9Xvoh$useState)(UNSTABLE_expandedKeysStack === null || UNSTABLE_expandedKeysStack === void 0 ? void 0 : UNSTABLE_expandedKeysStack.length);
    let isOpen = (0, $9Xvoh$useMemo)(()=>UNSTABLE_expandedKeysStack[submenuLevel] === triggerKey, [
        UNSTABLE_expandedKeysStack,
        triggerKey,
        submenuLevel
    ]);
    let [focusStrategy, setFocusStrategy] = (0, $9Xvoh$useState)(null);
    let open = (0, $9Xvoh$useCallback)((focusStrategy = null)=>{
        setFocusStrategy(focusStrategy);
        UNSTABLE_openSubmenu(triggerKey, submenuLevel);
    }, [
        UNSTABLE_openSubmenu,
        submenuLevel,
        triggerKey
    ]);
    let close = (0, $9Xvoh$useCallback)(()=>{
        setFocusStrategy(null);
        UNSTABLE_closeSubmenu(triggerKey, submenuLevel);
    }, [
        UNSTABLE_closeSubmenu,
        submenuLevel,
        triggerKey
    ]);
    let toggle = (0, $9Xvoh$useCallback)((focusStrategy = null)=>{
        setFocusStrategy(focusStrategy);
        if (isOpen) close();
        else open(focusStrategy);
    }, [
        close,
        open,
        isOpen
    ]);
    return (0, $9Xvoh$useMemo)(()=>({
            focusStrategy: focusStrategy,
            isOpen: isOpen,
            open: open,
            close: close,
            closeAll: closeAll,
            submenuLevel: submenuLevel,
            // TODO: Placeholders that aren't used but give us parity with OverlayTriggerState so we can use this in Popover. Refactor if we update Popover via
            // https://github.com/adobe/react-spectrum/pull/4976#discussion_r1336472863
            setOpen: ()=>{},
            toggle: toggle
        }), [
        isOpen,
        open,
        close,
        closeAll,
        focusStrategy,
        toggle,
        submenuLevel
    ]);
}




export {$a28c903ee9ad8dc5$export$79fefeb1c2091ac3 as useMenuTriggerState, $e5614764aa47eb35$export$d39fdbfa42246ac4 as UNSTABLE_useSubmenuTriggerState};
//# sourceMappingURL=module.js.map
