"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRadioGroup = useRadioGroup;

var _utils = require("@react-native-aria/utils");

/**
 * Provides the behavior and accessibility implementation for a radio group component.
 * Radio groups allow users to select a single item from a list of mutually exclusive options.
 * @param props - Props for the radio group.
 * @param state - State for the radio group, as returned by `useRadioGroupState`.
 */
function useRadioGroup(props, _state) {
  let {
    isDisabled
  } = props;
  return {
    radioGroupProps: {
      'aria-label': (0, _utils.getLabel)(props),
      'role': 'radiogroup',
      'aria-disabled': isDisabled
    },
    labelProps: {}
  };
}
//# sourceMappingURL=useRadioGroup.js.map