"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRadio = useRadio;

var _utils = require("@react-aria/utils");

var _interactions = require("@react-native-aria/interactions");

var _utils2 = require("@react-native-aria/utils");

/**
 * Provides the behavior and accessibility implementation for an individual
 * radio button in a radio group.
 * @param props - Props for the radio.
 * @param state - State for the radio group, as returned by `useRadioGroupState`.
 * @param ref - Ref to the HTML input element.
 */
function useRadio(props, state, _ref) {
  var _preventChanges;

  let {
    value,
    isReadOnly,
    isDisabled,
    children
  } = props;
  let hasChildren = children != null;
  const label = (0, _utils2.getLabel)(props);

  if (!hasChildren && !label) {
    console.warn('If you do not provide children, you must specify an aria-label for accessibility');
  }

  let preventChanges = isDisabled || isReadOnly;
  preventChanges = (_preventChanges = preventChanges) !== null && _preventChanges !== void 0 ? _preventChanges : false;
  let checked = state.selectedValue === value;

  let onPress = () => {
    state.setSelectedValue(value);
  };

  let {
    pressProps
  } = (0, _interactions.usePress)({
    isDisabled: preventChanges,
    onPress
  });
  return {
    inputProps: (0, _utils.mergeProps)(props, { ...pressProps,
      checked,
      'disabled': preventChanges,
      value,
      'aria-label': label,
      'role': 'radio',
      'aria-disabled': preventChanges,
      'aria-checked': checked
    })
  };
}
//# sourceMappingURL=useRadio.js.map