"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOverlayPosition = useOverlayPosition;
var _calculatePosition = require("./calculatePosition");
var _react = require("react");
var _useCloseOnScroll = require("./useCloseOnScroll");
var _utils = require("@react-native-aria/utils");
//@ts-nocheck
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

// @ts-ignore
let visualViewport = typeof window !== 'undefined' && window.visualViewport;

/**
 * Handles positioning overlays like popovers and menus relative to a trigger
 * element, and updating the position when the window resizes.
 */
function useOverlayPosition(props) {
  var _targetRef$current, _targetRef$current2;
  const direction = (0, _utils.isRTL)() ? 'rtl' : undefined;
  let {
    targetRef,
    overlayRef,
    scrollRef = overlayRef,
    placement = 'bottom',
    containerPadding = 12,
    shouldFlip = true,
    boundaryElement = typeof document !== 'undefined' ? document.body : null,
    offset = 0,
    crossOffset = 0,
    shouldUpdatePosition = true,
    isOpen = true,
    shouldOverlapWithTrigger = false,
    onClose
  } = props;
  let [position, setPosition] = (0, _react.useState)({
    position: {},
    arrowOffsetLeft: undefined,
    arrowOffsetTop: undefined,
    maxHeight: undefined,
    placement: undefined
  });
  let deps = [shouldUpdatePosition, placement, overlayRef.current, (_targetRef$current = targetRef.current) === null || _targetRef$current === void 0 ? void 0 : _targetRef$current.offsetLeft, (_targetRef$current2 = targetRef.current) === null || _targetRef$current2 === void 0 ? void 0 : _targetRef$current2.offsetTop, scrollRef.current, containerPadding, shouldFlip, boundaryElement, offset, crossOffset, isOpen, direction, shouldOverlapWithTrigger];
  let updatePosition = (0, _react.useCallback)(() => {
    if (shouldUpdatePosition === false || !isOpen || !overlayRef.current || !targetRef.current || !scrollRef.current || !boundaryElement) {
      return;
    }
    setPosition((0, _calculatePosition.calculatePosition)({
      placement: translateRTL(placement, direction),
      overlayNode: overlayRef.current,
      targetNode: targetRef.current,
      scrollNode: scrollRef.current,
      padding: containerPadding,
      shouldFlip,
      boundaryElement,
      offset,
      crossOffset,
      shouldOverlapWithTrigger
    }));
  }, deps);

  // Update position when anything changes
  (0, _utils.useLayoutEffect)(updatePosition, deps);

  // Update position on window resize
  useResize(updatePosition);

  // Reposition the overlay and do not close on scroll while the visual viewport is resizing.
  // This will ensure that overlays adjust their positioning when the iOS virtual keyboard appears.
  let isResizing = (0, _react.useRef)(false);
  (0, _utils.useLayoutEffect)(() => {
    let timeout;
    let onResize = () => {
      isResizing.current = true;
      clearTimeout(timeout);
      timeout = setTimeout(() => {
        isResizing.current = false;
      }, 500);
      updatePosition();
    };
    visualViewport === null || visualViewport === void 0 || visualViewport.addEventListener('resize', onResize);
    return () => {
      visualViewport === null || visualViewport === void 0 || visualViewport.removeEventListener('resize', onResize);
    };
  }, [updatePosition]);
  let close = (0, _react.useCallback)(() => {
    if (!isResizing.current) {
      onClose();
    }
  }, [onClose, isResizing]);

  // When scrolling a parent scrollable region of the trigger (other than the body),
  // we hide the popover. Otherwise, its position would be incorrect.
  (0, _useCloseOnScroll.useCloseOnScroll)({
    triggerRef: targetRef,
    isOpen,
    onClose: onClose ? close : undefined
  });

  // useLayoutEffect(() => {
  //   const mutationObserver = new MutationObserver((mutations) => {
  //     updatePosition();
  //     mutations.forEach((mutation) => {
  //       // if (mutation.attributeName === 'style') {
  //       //   const transform = mutation.target.style.transform;
  //       //   if (transform) {
  //       //     const match = transform.match(/scale\((.+)\)/);
  //       //     if (match) {
  //       //       const scale = parseFloat(match[1]);
  //       //       console.log(`Scale: ${scale}`);
  //       //       // updatePosition();
  //       //     }
  //       //   }
  //       // }
  //     });
  //   });

  //   mutationObserver.observe(overlayRef?.current, { attributes: true });

  //   return () => mutationObserver.disconnect();
  // }, [overlayRef, updatePosition]);

  return {
    rendered: true,
    overlayProps: {
      style: {
        position: 'absolute',
        zIndex: 100000,
        // should match the z-index in ModalTrigger
        ...position.position,
        maxHeight: position.maxHeight
      }
    },
    placement: position.placement,
    arrowProps: {
      style: {
        left: position.arrowOffsetLeft,
        top: position.arrowOffsetTop
      }
    },
    updatePosition
  };
}
function useResize(onResize) {
  (0, _utils.useLayoutEffect)(() => {
    window.addEventListener('resize', onResize, false);
    return () => {
      window.removeEventListener('resize', onResize, false);
    };
  }, [onResize]);
}
function translateRTL(position, direction) {
  if (direction === 'rtl') {
    return position.replace('start', 'right').replace('end', 'left');
  }
  return position.replace('start', 'left').replace('end', 'right');
}
//# sourceMappingURL=useOverlayPosition.js.map