"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverlayContainer = OverlayContainer;
exports.OverlayProvider = void 0;
exports.PortalProvider = PortalProvider;
var _react = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const PortalContext = /*#__PURE__*/_react.default.createContext(null);
let globalOverlayCounter = 0;
function PortalProvider(props) {
  const [items, setItems] = _react.default.useState([]);
  const setOverlayItem = element => {
    const overlayId = ++globalOverlayCounter;
    setItems(prev => prev.concat([{
      id: overlayId,
      node: element
    }]));
    return overlayId;
  };
  const updateOverlayItem = (id, node) => {
    setItems(prev => {
      const overlayItem = prev.find(item => item.id == id);
      if (!overlayItem) {
        return prev.concat([{
          id: id,
          node
        }]);
      } else {
        return prev.map(item => {
          if (item.id === id) {
            return {
              id,
              node
            };
          }
          return item;
        });
      }
    });
  };
  const removeOverlayItem = id => {
    setItems(prev => {
      const newItems = prev.filter(item => item.id !== id);
      return newItems;
    });
  };
  return /*#__PURE__*/_react.default.createElement(PortalContext.Provider, {
    value: {
      items,
      setOverlayItem,
      removeOverlayItem,
      updateOverlayItem,
      isSSR: props === null || props === void 0 ? void 0 : props.isSSR
    }
  }, props.children, items.map(item => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: item.id
    }, item.node);
  }));
}
function OverlayView({
  style,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement(_reactNative.View, _extends({
    pointerEvents: "box-none",
    style: [_reactNative.StyleSheet.absoluteFill, style],
    collapsable: false
  }, props));
}
const OverlayProvider = exports.OverlayProvider = PortalProvider;
function OverlayContainer(props) {
  const context = usePortalProvider();
  const overlayId = _react.default.useRef(undefined);
  const element = /*#__PURE__*/_react.default.createElement(OverlayView, props);
  (0, _react.useEffect)(() => {
    // Mount
    if (overlayId.current === undefined) {
      overlayId.current = context === null || context === void 0 ? void 0 : context.setOverlayItem(element);
    }
    // Update
    else {
      if (overlayId.current) {
        context === null || context === void 0 || context.updateOverlayItem(overlayId.current, element);
      }
    }
  },
  // To re-render the child
  [props]);

  // Unmount
  (0, _react.useEffect)(() => {
    return () => {
      if (overlayId.current) {
        context === null || context === void 0 || context.removeOverlayItem(overlayId.current);
      }
    };
  }, []);

  // Rendering elements for SSR
  if (context !== null && context !== void 0 && context.isSSR && !overlayId.current) {
    return /*#__PURE__*/_react.default.createElement(_reactNative.View, {
      style: {
        display: 'none'
      }
    }, element);
  }
  return null;
}
function usePortalProvider() {
  const context = _react.default.useContext(PortalContext);
  return context;
}
//# sourceMappingURL=Portal.js.map