"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOption = useOption;

var _collections = require("@react-stately/collections");

var _utils = require("./utils");

var _interactions = require("@react-aria/interactions");

var _interactions2 = require("@react-native-aria/interactions");

var _utils2 = require("@react-aria/utils");

var _selection = require("@react-aria/selection");

var _utils3 = require("@react-native-aria/utils");

/**
 * Provides the behavior and accessibility implementation for an option in a listbox.
 * See `useListBox` for more details about listboxes.
 * @param props - Props for the option.
 * @param state - State for the listbox, as returned by `useListState`.
 */
function useOption(props, state, ref) {
  let {
    isSelected,
    isDisabled,
    key,
    shouldSelectOnPressUp,
    shouldFocusOnHover,
    isVirtualized,
    shouldUseVirtualFocus
  } = props;
  let labelId = (0, _utils2.useSlotId)();
  let descriptionId = (0, _utils2.useSlotId)();
  let _optionProps = {
    'role': 'option',
    'aria-disabled': isDisabled,
    'aria-selected': isSelected
  }; // Safari with VoiceOver on macOS misreads options with aria-labelledby or aria-label as simply "text".
  // We should not map slots to the label and description on Safari and instead just have VoiceOver read the textContent.
  // https://bugs.webkit.org/show_bug.cgi?id=209279

  if (!((0, _utils2.isMac)() && (0, _utils2.isWebKit)())) {
    _optionProps['aria-label'] = props['aria-label'];
    _optionProps['aria-labelledby'] = labelId;
    _optionProps['aria-describedby'] = descriptionId;
  }

  if (isVirtualized) {
    //@ts-ignore
    _optionProps['aria-posinset'] = state.collection.getItem(key).index + 1;
    _optionProps['aria-setsize'] = (0, _collections.getItemCount)(state.collection);
  }

  let {
    itemProps
  } = (0, _selection.useSelectableItem)({
    selectionManager: state.selectionManager,
    //@ts-ignore
    key,
    ref,
    shouldSelectOnPressUp,
    isVirtualized,
    shouldUseVirtualFocus
  });
  let {
    pressProps
  } = (0, _interactions2.usePress)({ ...itemProps,
    isDisabled,
    preventFocusOnPress: shouldUseVirtualFocus
  });
  let {
    hoverProps
  } = (0, _interactions2.useHover)({
    isDisabled: isDisabled || !shouldFocusOnHover,

    onHoverStart() {
      if (!(0, _interactions.isFocusVisible)()) {
        state.selectionManager.setFocused(true); //@ts-ignore

        state.selectionManager.setFocusedKey(key);
      }
    }

  }, ref); // Putting this as a last resort, after several hours of debugging.
  // Why?
  // tabListProps adds onMouseDown with preventDefault in useSelectableCollection.ts (React Aria) and react-native-web uses onClick for onPress.
  // This results in tab button not getting focused when clicked
  // See this example - https://codesandbox.io/s/issue-i-know-but-dont-know-why-1-ydyw5?file=/src/App.js

  const onMouseDown = e => e.stopPropagation();

  _optionProps = { ..._optionProps,
    ...(0, _utils2.mergeProps)(pressProps, hoverProps),
    //@ts-ignore
    id: (0, _utils.getItemId)(state, key),
    onMouseDown
  };
  const optionProps = (0, _utils3.useMapDomPropsToRN)(_optionProps, ref);
  return {
    optionProps,
    labelProps: {
      nativeID: labelId
    },
    descriptionProps: {
      nativeID: descriptionId
    }
  };
}
//# sourceMappingURL=useOption.web.js.map