import React from 'react';
import { mergeProps } from '@react-aria/utils';
export function usePress({
  isDisabled,
  onPress,
  onPressStart,
  onPressEnd,
  onPressUp,
  // No onPressUp on RN.
  onPressChange,
  isPressed: isPressedProp,
  ...restProps
}) {
  let [isPressed, setPressed] = React.useState(false);
  let pressProps = {
    onPress: e => {
      if (isDisabled) return;
      onPress && onPress(e);
    },
    onPressIn: e => {
      if (isDisabled) return;
      onPressStart && onPressStart(e);
      setPressed(true);
      onPressChange && onPressChange(true);
    },
    onPressOut: e => {
      if (isDisabled) return;
      onPressEnd && onPressEnd(e);
      setPressed(false);
      onPressChange && onPressChange(false);
      onPressUp && onPressUp(e);
    }
  };
  pressProps = mergeProps(pressProps, restProps);
  return {
    isPressed: isPressedProp || isPressed,
    pressProps
  };
}
//# sourceMappingURL=usePress.js.map