"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckboxGroupItem = useCheckboxGroupItem;
var _useCheckbox = require("./useCheckbox");
var _toggle = require("@react-stately/toggle");
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/**
 * Provides the behavior and accessibility implementation for a checkbox component contained within a checkbox group.
 * Checkbox groups allow users to select multiple items from a list of options.
 * @param props - Props for the checkbox.
 * @param state - State for the checkbox, as returned by `useCheckboxGroupState`.
 * @param inputRef - A ref for the HTML input element.
 */
function useCheckboxGroupItem(props, state, inputRef) {
  const toggleState = (0, _toggle.useToggleState)({
    isReadOnly: props.isReadOnly || state.isReadOnly,
    //@ts-ignore
    isSelected: state.isSelected(props.value),
    onChange(isSelected) {
      if (isSelected) {
        //@ts-ignore
        state.addValue(props.value);
      } else {
        //@ts-ignore
        state.removeValue(props.value);
      }
      if (props.onChange) {
        props.onChange(isSelected);
      }
    }
  });
  let {
    inputProps
  } = (0, _useCheckbox.useCheckbox)({
    ...props,
    isReadOnly: props.isReadOnly || state.isReadOnly,
    isDisabled: props.isDisabled || state.isDisabled
  }, toggleState, inputRef);
  return {
    inputProps
  };
}
//# sourceMappingURL=useCheckboxGroupItem.js.map