import { ReactNode } from 'react';
import { PressEvents } from '@react-native-aria/interactions';
import { AccessibilityProps, PressableProps } from 'react-native';
interface ButtonProps extends PressEvents {
    /** Whether the button is disabled. */
    isDisabled?: boolean;
    /** The content to display in the button. */
    children?: ReactNode;
}
export interface RNAriaButtonProps extends AccessibilityProps, ButtonProps {
}
export interface ButtonAria {
    /** Props for the button element. */
    buttonProps: PressableProps;
    /** Whether the button is currently pressed. */
    isPressed: boolean;
}
export declare function useButton(props: RNAriaButtonProps): ButtonAria;
export {};
