import {mergeProps as $4vDl6$mergeProps, filterDOMProps as $4vDl6$filterDOMProps, useFormReset as $4vDl6$useFormReset, useId as $4vDl6$useId} from "@react-aria/utils";
import {useFocusable as $4vDl6$useFocusable, getFocusableTreeWalker as $4vDl6$getFocusableTreeWalker} from "@react-aria/focus";
import {useFormValidation as $4vDl6$useFormValidation} from "@react-aria/form";
import {usePress as $4vDl6$usePress, useFocusWithin as $4vDl6$useFocusWithin} from "@react-aria/interactions";
import {useField as $4vDl6$useField} from "@react-aria/label";
import {useLocale as $4vDl6$useLocale} from "@react-aria/i18n";

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ /*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ const $884aeceb3d67f00f$export$37b65e5b5444d35c = new WeakMap();





function $0d5c49892c1215da$export$37b0961d2f4751e2(props, state, ref) {
    let { value: value, children: children, "aria-label": ariaLabel, "aria-labelledby": ariaLabelledby } = props;
    const isDisabled = props.isDisabled || state.isDisabled;
    let hasChildren = children != null;
    let hasAriaLabel = ariaLabel != null || ariaLabelledby != null;
    if (!hasChildren && !hasAriaLabel) console.warn("If you do not provide children, you must specify an aria-label for accessibility");
    let checked = state.selectedValue === value;
    let onChange = (e)=>{
        e.stopPropagation();
        state.setSelectedValue(value);
    };
    let { pressProps: pressProps, isPressed: isPressed } = (0, $4vDl6$usePress)({
        isDisabled: isDisabled
    });
    // iOS does not toggle radios if you drag off and back onto the label, so handle it ourselves.
    let { pressProps: labelProps, isPressed: isLabelPressed } = (0, $4vDl6$usePress)({
        isDisabled: isDisabled,
        onPress () {
            state.setSelectedValue(value);
        }
    });
    let { focusableProps: focusableProps } = (0, $4vDl6$useFocusable)((0, $4vDl6$mergeProps)(props, {
        onFocus: ()=>state.setLastFocusedValue(value)
    }), ref);
    let interactions = (0, $4vDl6$mergeProps)(pressProps, focusableProps);
    let domProps = (0, $4vDl6$filterDOMProps)(props, {
        labelable: true
    });
    let tabIndex = -1;
    if (state.selectedValue != null) {
        if (state.selectedValue === value) tabIndex = 0;
    } else if (state.lastFocusedValue === value || state.lastFocusedValue == null) tabIndex = 0;
    if (isDisabled) tabIndex = undefined;
    let { name: name, descriptionId: descriptionId, errorMessageId: errorMessageId, validationBehavior: validationBehavior } = (0, $884aeceb3d67f00f$export$37b65e5b5444d35c).get(state);
    (0, $4vDl6$useFormReset)(ref, state.selectedValue, state.setSelectedValue);
    (0, $4vDl6$useFormValidation)({
        validationBehavior: validationBehavior
    }, state, ref);
    return {
        labelProps: (0, $4vDl6$mergeProps)(labelProps, {
            onClick: (e)=>e.preventDefault()
        }),
        inputProps: (0, $4vDl6$mergeProps)(domProps, {
            ...interactions,
            type: "radio",
            name: name,
            tabIndex: tabIndex,
            disabled: isDisabled,
            required: state.isRequired && validationBehavior === "native",
            checked: checked,
            value: value,
            onChange: onChange,
            "aria-describedby": [
                props["aria-describedby"],
                state.isInvalid ? errorMessageId : null,
                descriptionId
            ].filter(Boolean).join(" ") || undefined
        }),
        isDisabled: isDisabled,
        isSelected: checked,
        isPressed: isPressed || isLabelPressed
    };
}


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 





function $430f30ed08ec25fa$export$62b9571f283ff5c2(props, state) {
    let { name: name, isReadOnly: isReadOnly, isRequired: isRequired, isDisabled: isDisabled, orientation: orientation = "vertical", validationBehavior: validationBehavior = "aria" } = props;
    let { direction: direction } = (0, $4vDl6$useLocale)();
    let { isInvalid: isInvalid, validationErrors: validationErrors, validationDetails: validationDetails } = state.displayValidation;
    let { labelProps: labelProps, fieldProps: fieldProps, descriptionProps: descriptionProps, errorMessageProps: errorMessageProps } = (0, $4vDl6$useField)({
        ...props,
        // Radio group is not an HTML input element so it
        // shouldn't be labeled by a <label> element.
        labelElementType: "span",
        isInvalid: state.isInvalid,
        errorMessage: props.errorMessage || validationErrors
    });
    let domProps = (0, $4vDl6$filterDOMProps)(props, {
        labelable: true
    });
    // When the radio group loses focus, reset the focusable radio to null if
    // there is no selection. This allows tabbing into the group from either
    // direction to go to the first or last radio.
    let { focusWithinProps: focusWithinProps } = (0, $4vDl6$useFocusWithin)({
        onBlurWithin (e) {
            var _props_onBlur;
            (_props_onBlur = props.onBlur) === null || _props_onBlur === void 0 ? void 0 : _props_onBlur.call(props, e);
            if (!state.selectedValue) state.setLastFocusedValue(null);
        },
        onFocusWithin: props.onFocus,
        onFocusWithinChange: props.onFocusChange
    });
    let onKeyDown = (e)=>{
        let nextDir;
        switch(e.key){
            case "ArrowRight":
                if (direction === "rtl" && orientation !== "vertical") nextDir = "prev";
                else nextDir = "next";
                break;
            case "ArrowLeft":
                if (direction === "rtl" && orientation !== "vertical") nextDir = "next";
                else nextDir = "prev";
                break;
            case "ArrowDown":
                nextDir = "next";
                break;
            case "ArrowUp":
                nextDir = "prev";
                break;
            default:
                return;
        }
        e.preventDefault();
        let walker = (0, $4vDl6$getFocusableTreeWalker)(e.currentTarget, {
            from: e.target
        });
        let nextElem;
        if (nextDir === "next") {
            nextElem = walker.nextNode();
            if (!nextElem) {
                walker.currentNode = e.currentTarget;
                nextElem = walker.firstChild();
            }
        } else {
            nextElem = walker.previousNode();
            if (!nextElem) {
                walker.currentNode = e.currentTarget;
                nextElem = walker.lastChild();
            }
        }
        if (nextElem) {
            // Call focus on nextElem so that keyboard navigation scrolls the radio into view
            nextElem.focus();
            state.setSelectedValue(nextElem.value);
        }
    };
    let groupName = (0, $4vDl6$useId)(name);
    (0, $884aeceb3d67f00f$export$37b65e5b5444d35c).set(state, {
        name: groupName,
        descriptionId: descriptionProps.id,
        errorMessageId: errorMessageProps.id,
        validationBehavior: validationBehavior
    });
    return {
        radioGroupProps: (0, $4vDl6$mergeProps)(domProps, {
            // https://www.w3.org/TR/wai-aria-1.2/#radiogroup
            role: "radiogroup",
            onKeyDown: onKeyDown,
            "aria-invalid": state.isInvalid || undefined,
            "aria-errormessage": props["aria-errormessage"],
            "aria-readonly": isReadOnly || undefined,
            "aria-required": isRequired || undefined,
            "aria-disabled": isDisabled || undefined,
            "aria-orientation": orientation,
            ...fieldProps,
            ...focusWithinProps
        }),
        labelProps: labelProps,
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps,
        isInvalid: isInvalid,
        validationErrors: validationErrors,
        validationDetails: validationDetails
    };
}




export {$0d5c49892c1215da$export$37b0961d2f4751e2 as useRadio, $430f30ed08ec25fa$export$62b9571f283ff5c2 as useRadioGroup};
//# sourceMappingURL=module.js.map
