import { PluralCategory } from 'make-plural';

declare class EventEmitter<Events extends {
    [name: string]: (...args: any[]) => any;
}> {
    private readonly _events;
    on(event: keyof Events, listener: Events[typeof event]): () => void;
    removeListener(event: keyof Events, listener: Events[typeof event]): void;
    emit(event: keyof Events, ...args: Parameters<Events[typeof event]>): void;
    private _hasEvent;
}

type MessageOptions = {
    message?: string;
    context?: string;
    formats?: Formats;
};
type Locale = string;
type Locales = Locale | Locale[];
type Formats = Record<string, Intl.DateTimeFormatOptions | Intl.NumberFormatOptions>;
type Values = Record<string, unknown>;
type LocaleData = {
    plurals?: (n: number, ordinal?: boolean) => PluralCategory;
};
type AllLocaleData = Record<Locale, LocaleData>;
type CompiledIcuChoices = Record<string, CompiledMessage> & {
    offset: number;
};
type CompiledMessageToken = string | [name: string, type?: string, format?: null | string | CompiledIcuChoices];
type CompiledMessage = string | CompiledMessageToken[];
type Messages = Record<string, CompiledMessage>;
type AllMessages = Record<Locale, Messages>;
type MessageDescriptor = {
    id?: string;
    comment?: string;
    message?: string;
    context?: string;
    values?: Record<string, unknown>;
};
type MissingMessageEvent = {
    locale: Locale;
    id: string;
    context?: string;
};
type MissingHandler = string | ((locale: string, id: string, context: string) => string);
type setupI18nProps = {
    locale?: Locale;
    locales?: Locales;
    messages?: AllMessages;
    localeData?: AllLocaleData;
    missing?: MissingHandler;
};
type Events = {
    change: () => void;
    missing: (event: MissingMessageEvent) => void;
};
declare class I18n extends EventEmitter<Events> {
    private _locale;
    private _locales;
    private _localeData;
    private _messages;
    private _missing;
    constructor(params: setupI18nProps);
    get locale(): string;
    get locales(): Locales;
    get messages(): Messages;
    get localeData(): LocaleData;
    private _loadLocaleData;
    loadLocaleData(allLocaleData: AllLocaleData): void;
    loadLocaleData(locale: Locale, localeData: LocaleData): void;
    private _load;
    load(allMessages: AllMessages): void;
    load(locale: Locale, messages: Messages): void;
    activate(locale: Locale, locales?: Locales): void;
    _(id: MessageDescriptor | string, values?: Values | undefined, { message, formats, context }?: MessageOptions | undefined): string;
    date(value: string | Date, format?: Intl.DateTimeFormatOptions): string;
    number(value: number, format?: Intl.NumberFormatOptions): string;
}
declare function setupI18n(params?: setupI18nProps): I18n;

declare function date(locales: Locales, format?: Intl.DateTimeFormatOptions, memoize?: boolean): (value: string | Date) => string;
declare function number(locales: Locales, format?: Intl.NumberFormatOptions, memoize?: boolean): (value: number) => string;

declare const formats_date: typeof date;
declare const formats_number: typeof number;
declare namespace formats {
  export {
    formats_date as date,
    formats_number as number,
  };
}

declare const i18n: I18n;

export { AllLocaleData, AllMessages, I18n, Locale, LocaleData, Locales, MessageDescriptor, Messages, formats, i18n, setupI18n };
