"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStats = getStats;
exports.printStats = printStats;
var _cliTable = _interopRequireDefault(require("cli-table"));
var _chalk = _interopRequireDefault(require("chalk"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function getStats(catalog) {
  return [Object.keys(catalog).length, Object.keys(catalog).filter(key => !catalog[key].translation).length];
}
function printStats(config, catalogs) {
  const table = new _cliTable.default({
    head: ["Language", "Total count", "Missing"],
    colAligns: ["left", "middle", "middle"],
    style: {
      head: ["green"],
      border: [],
      compact: true
    }
  });
  Object.keys(catalogs).forEach(locale => {
    const catalog = catalogs[locale];
    // catalog is null if no catalog exists on disk and the locale
    // was not extracted due to a `--locale` filter
    const [all, translated] = catalog ? getStats(catalog) : ["-", "-"];
    if (config.sourceLocale === locale) {
      table.push({
        [`${_chalk.default.bold(locale)} (source)`]: [all, "-"]
      });
    } else {
      table.push({
        [locale]: [all, translated]
      });
    }
  });
  return table;
}